<?php

/* -------------------------------------------------------------------------
	PC2M Website Transcoder for Mobile Clients
	Copyright (C) 2005-2006 ucb.rcdtokyo
	http://www.rcdtokyo.com/pc2m/note/

	Version 0.9.18 (beta) issued June 9, 2006

	ΥץϡFree Software FoundationˤGNU General Public
	LicenseΥС2뤤ϤʹߤΥСʰʲGPLפȸˤ
	Ť饤󥹤ޤΥץѼԤϡɬ GPLʸ
	ǧƤGPLʸϡ֥ http://www.gnu.org/licenses/
	ˤơ뤤ϡFree Software Foundation, Inc., 59 Temple Place - Suite
	330, Boston, MA 02111-1307 USAʸդ뤳ȤǤޤ
	ΥץϡPublic DomainʤɤǤϤʤ
	ޤ
	ΥץϡGPLȿʤ¤ꡢѤޤतʤ
	ŪǤѤ¤ΤǤϤޤ󡣤ޤΥץϡGPL
	ʤƤʪƱͤGPL˴Ť饤󥹤
	ʤФʤʤȤﲼǡۤѤʤɤԤȤǤޤ
	ΥץϡͭѤʤΤǤ뤳Ȥä󶡤ΤǤϤޤ
	ŪФŬʤɤۼݾڤޤࡢʤΤ
	ڤΤǤϤޤ󡣤ʤѤϡƼǤˤ
	ԤäƤ
------------------------------------------------------------------------- */

define('DEBUG_MODE', false);
if (defined('DEBUG_MODE') and DEBUG_MODE) {
	ini_set('display_errors', '1');
	error_reporting(E_ALL);
	function microtime_float() {
		list($usec, $sec) = explode(" ", microtime());
		return ((float)$usec + (float)$sec);
	}
	$elaps = 0;
	$time_start = microtime_float();
}

@include_once 'Config.inc.php';
require_once 'ClientDetect.class.php';
$client =& new ClientDetect();
if (((defined('ALLOW_ONLYMOBILE') and ALLOW_ONLYMOBILE === true)
	or (defined('RESTRICT_MOZILLA_AGENT') and RESTRICT_MOZILLA_AGENT === true))
	and !$client->is_mobile) {
	if (!isset($exclude_iprange) or
		!$client->_compareIp($client->_dumpAddress($_SERVER['REMOTE_ADDR']), $exclude_iprange)) {
		header("HTTP/1.0 403 Forbidden");
		header("Content-Type:text/plain");
		exit('Access forbidden');
	}
}
define('OUTPUT_ENC', 'SJIS');
define('INT_ENC', 'EUC-JP');
mb_language('Japanese');
mb_internal_encoding(INT_ENC);
mb_detect_order('ASCII, JIS, UTF-8, EUC-JP, SJIS');
if (defined('IMAGE_ENABLED') and IMAGE_ENABLED) {
	if (!defined('IMAGE_CONVERTER')) {
		define('IMAGE_CONVERTER', basename($_SERVER['SCRIPT_NAME']));
	}
} elseif (!defined('IMAGE_CONVERTER')) {
	define('IMAGE_CONVERTER', false);
}
if (!defined('KEY_PREFIX')) {
	define('KEY_PREFIX', '');
}
if (!defined('SIZE_REDUNDANCY')) {
	define('SIZE_REDUNDANCY', 1000);
}
if (!defined('URL_REDUNDANCY')) {
	define('URL_REDUNDANCY', 4);
}
if (!defined('ALLOWABLE_CLENGTH')) {
	define('ALLOWABLE_CLENGTH', 300000);
}
if (!defined('MAX_META_REDIRECT')) {
	define('MAX_META_REDIRECT', 5);
}
if (!defined('ALLOWABLE_PIXSIZE')) {
	define('ALLOWABLE_PIXSIZE', 640);
}
if (!defined('AVERAGE_COMPRESSION_RATIO')) {
	define('AVERAGE_COMPRESSION_RATIO', 50);
}
if (!defined('AVERAGE_PALETTE_BIT')) {
	define('AVERAGE_PALETTE_BIT', 6);
}
if (!defined('KANA_CONVOPT')) {
	define('KANA_CONVOPT', 'ask');
}
if (!defined('SESSION_ID_LENGTH')) {
	define('SESSION_ID_LENGTH', 32);
}
if (!defined('SESSION_INSECURE_LIFETIME')) {
	define('SESSION_INSECURE_LIFETIME', 300);
}
if (!defined('SESSION_SECURE_LIFETIME')) {
	define('SESSION_SECURE_LIFETIME', SESSION_INSECURE_LIFETIME);
}
if (!defined('MAX_HISTORY_KEEP')) {
	define('MAX_HISTORY_KEEP', 30);
}
define('SHOW_PASSINPUT',
	$client->is_postcapable
	or !defined('USE_ONLYPOST_FORPASS')
	or !USE_ONLYPOST_FORPASS
);
$remote_url = null;
$content = null;
$title = null;
$rss_url = null;
$rss = array();
$mobile_url = null;
$body_elements = array();
$start_link = null;
$next_link = null;
$copy_link = null;
$next_trim = null;
$total_chars = null;
$new_image = array();
$image_quality = null;
$form_hidden = null;
$_kana_convopt = null;
$_refresh_count = 0;
$_history_key = null;
$_is_error = false;
$_is_httperror = false;
$_has_sessionid_leakrisk = false;
$_keys = array('d', 'c', 's', 'f', 'o', 'v', 'l', 'k', 'a', 'm', 'e', 'w', 'h', 't', 'q', 'i', 'p', 'r', 'u');
$_remote_args = empty($_POST)? $_GET: $_POST;
$_raw_query = $_SERVER['QUERY_STRING'];
$_ext_urlenc_search = array('-', '.', '_');
$_ext_urlenc_replace = array('%2D', '%2E', '%5F');
$_key_prefix = str_replace($_ext_urlenc_search, $_ext_urlenc_replace, urlencode(KEY_PREFIX));
if (!preg_match('/'.$_key_prefix.'/i', $_raw_query)) {
	$_key_prefix = urlencode(KEY_PREFIX);
}
foreach ($_keys as $key) {
	if (isset($_remote_args[KEY_PREFIX.$key])) {
		$local_args[$key] = mb_convert_encoding($_remote_args[KEY_PREFIX.$key], INT_ENC, OUTPUT_ENC);
		unset($_remote_args[KEY_PREFIX.$key]);
		if ($key == 'u') {
			$search = "'&?".$_key_prefix.$key."='i";
		} else {
			$search = "'&?".$_key_prefix.$key."=[^&]*'i";
		}
		$_raw_query = preg_replace($search, null, $_raw_query);
	} else {
		$local_args[$key] = null;
	}
}
$_raw_query = preg_replace('/^(?:&|\+|%20|%81%40|\x20)+(.*)$/', '$1', $_raw_query);
define('ENABLE_SESSION_COOKIE', isset($_COOKIE[KEY_PREFIX.'d']));
if (ENABLE_SESSION_COOKIE and $_COOKIE[KEY_PREFIX.'d'] == $local_args['d']) {
	$array = explode('&', $_SERVER['QUERY_STRING']);
	for ($i = 0; $i < count($array); $i++) {
		if (0 === strpos($array[$i], KEY_PREFIX.'d='.$local_args['d'])) {
			unset($array[$i]);
		}
	}
	$x = implode('&', $array);
	header('Location:http'.
		(isset($_SERVER['HTTPS']) and $_SERVER['HTTPS'] == 'on'? 's': null).'://'.
		$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'].'?'.$x);
	exit;
}
if (defined('ENABLE_SESSION') and ENABLE_SESSION === true) {
	ini_set('session.save_handler', 'files');
	ini_set('session.referer_check', '');
	ini_set('session.use_cookies', '1');
	ini_set('session.use_only_cookies', '0');
	ini_set('session.cache_limiter', 'nocache');
	if (!defined('SESSION_COOKIE_PATH')) {
		session_set_cookie_params(0, getDirName($_SERVER['SCRIPT_NAME']));
	} else {
		session_set_cookie_params(0,
			(strrpos(SESSION_COOKIE_PATH, '/') == strlen(SESSION_COOKIE_PATH) -1)?
			SESSION_COOKIE_PATH: SESSION_COOKIE_PATH.'/');
	}
	session_name(KEY_PREFIX.'d');
	$_session_key = md5(
		(isset($_SERVER['HTTP_USER_AGENT'])? $_SERVER['HTTP_USER_AGENT']: null).
		$client->getSerialId().
		$client->getHostname().
		($client->is_mobile? 1: 0).
		(ENABLE_SESSION_COOKIE? 1: 0)
	);
	$_session_lifetime = (ENABLE_SESSION_COOKIE
		or ($client->getSerialId() !== null and $client->is_mobile))?
		SESSION_SECURE_LIFETIME:
		SESSION_INSECURE_LIFETIME;
	$_restart = true;
	if ($local_args['d'] or isset($_COOKIE[session_name()])) {
		if ($client->dev_type == 'au') {
			session_cache_limiter('nocache');
		} else {
			session_cache_limiter('none');
		}
		session_start();
		if (($local_args['a'] == 'l' and $client->dev_type == 'docomo' and $client->is_mobile)
			or (isset($_SESSION['identifier']) and $_SESSION['identifier'] == $_session_key
			and isset($_SESSION['atime']) and $_session_lifetime > time() - $_SESSION['atime'])) {
			$_restart = false;
		} else {
			$_SESSION = array();
			if (isset($_COOKIE[session_name()])) {
				setcookie(session_name(), '', time() -42000, '/');
			}
			session_destroy();
		}
	}
	if ($_restart) {
		if ($local_args['m']) {
			header('Location:'.basename($_SERVER['SCRIPT_NAME']));
			exit;
		}
		if (!$client->is_mobile
			and defined('RESTRICT_HOSTS_INDNSBL') and RESTRICT_HOSTS_INDNSBL === true) {
			if (isset($dnsbls) and false !== @include_once 'Net/DNSBL.php') {
				$dnsbl =& new Net_DNSBL();
				$dnsbl->setBlacklists($dnsbls);
				if ($dnsbl->isListed($_SERVER['REMOTE_ADDR'])) {
					header("HTTP/1.0 403 Forbidden");
					header("Content-Type:text/plain");
					exit('Access forbidden');
				}
			}
		}
		session_id(generateId(SESSION_ID_LENGTH));
		if ($client->dev_type == 'au') {
			session_cache_limiter('nocache');
		} else {
			session_cache_limiter('none');
		}
		session_start();
		$_SESSION['identifier'] = $_session_key;
	}
	$local_args['d'] = session_id();
	$_SESSION['atime'] = time();
	if ($local_args['c'] === null and isset($_SESSION['settings']['c'])) {
		$local_args['c'] = $_SESSION['settings']['c'];
	}
	if ($local_args['w'] === null and isset($_SESSION['settings']['w'])) {
		$local_args['w'] = $_SESSION['settings']['w'];
	}
	if ($local_args['v'] === null and isset($_SESSION['settings']['v'])) {
		$local_args['v'] = $_SESSION['settings']['v'];
	}
	if ($local_args['l'] === null and isset($_SESSION['settings']['l'])) {
		$local_args['l'] = $_SESSION['settings']['l'];
	}
	if ($local_args['k'] === null and isset($_SESSION['settings']['k'])) {
		$local_args['k'] = $_SESSION['settings']['k'];
	}
} else {
	$local_args['d'] = null;
}
if ($client->screen['color'] < 256) {
	$local_args['v'] = 0;
}
$_default_setting['v'] = 0;
$_default_setting['l'] = 0;
$_default_setting['k'] = 0;
if (defined('RICHTERM_THRESHOLD')
	and RICHTERM_THRESHOLD <= $client->getCacheSize()) {
	if (defined('RICHTERM_VISUAL')) {
		$_default_setting['v'] = RICHTERM_VISUAL;
	}
	if (defined('RICHTERM_LEGACYTAGS')) {
		$_default_setting['l'] = RICHTERM_LEGACYTAGS;
	}
	if (defined('RICHTERM_KANACONV')) {
		$_default_setting['k'] = RICHTERM_KANACONV;
	}
}
if ($local_args['v'] === null) {
	$local_args['v'] = $_default_setting['v'];
}
if ($local_args['l'] === null) {
	$local_args['l'] = $_default_setting['l'];
}
if ($local_args['k'] === null) {
	$local_args['k'] = $_default_setting['k'];
}
$script_self = basename($_SERVER['SCRIPT_NAME']).'?';
if ($local_args['d'] !== null and !ENABLE_SESSION_COOKIE) {
	$script_self = $script_self.strip_tags(SID).'&';
	$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'d" value="'.$local_args['d'].'">';
	if (isset($_SERVER['HTTP_REFERER'])) {
		$_has_sessionid_leakrisk = true;
		if ($local_args['v'] == 1) {
			$local_args['v'] = 2;
		}
	}
}
if (isset($_SESSION)) {
	$_SESSION['settings']['c'] = $local_args['c'];
	$_SESSION['settings']['w'] = $local_args['w'];
	$_SESSION['settings']['v'] = $local_args['v'];
	$_SESSION['settings']['l'] = $local_args['l'];
	$_SESSION['settings']['k'] = $local_args['k'];
}
if (!isset($_SESSION)
	or (defined('KEEP_SETTING_INQUERY') and KEEP_SETTING_INQUERY)) {
	if ($local_args['c']) {
		$script_self = $script_self.KEY_PREFIX.'c='.$local_args['c'].'&';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'c" value="'.$local_args['c'].'">';
	}
	if ($local_args['w'] and $local_args['w'] != $client->screen['width']) {
		$script_self = $script_self.KEY_PREFIX.'w='.$local_args['w'].'&';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'w" value="'.$local_args['w'].'">';
	}
	if ($local_args['v'] != $_default_setting['v']) {
		$script_self = $script_self.KEY_PREFIX.'v='.$local_args['v'].'&';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'v" value="'.$local_args['v'].'">';
	}
	if ($local_args['l'] != $_default_setting['l']) {
		$script_self = $script_self.KEY_PREFIX.'l='.$local_args['l'].'&';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'l" value="'.$local_args['l'].'">';
	}
	if ($local_args['k'] != $_default_setting['k']) {
		$script_self = $script_self.KEY_PREFIX.'k='.$local_args['k'].'&';
		$form_hidden .= '<input type="hidden" name="'.KEY_PREFIX.'k" value="'.$local_args['k'].'">';
	}
}
$script_host = 'http'.
	(isset($_SERVER['HTTPS']) and $_SERVER['HTTPS'] == 'on'? 's': null).
	'://'.$_SERVER['HTTP_HOST'];
$_kana_convopt = $local_args['k']? '': KANA_CONVOPT;
if ($local_args['a'] == 'h') {
	if (!isset($_SESSION['history']) or empty($_SESSION['history'])) {
		$content = sayError('ERROR_NOHISTORY');
	} else {
		$array = sortMultiArray($_SESSION['history'], 0);
		$content = '<ol>';
		$i = 0;
		foreach ($array as $key => $value) {
			$content .= '<li><a href="'.$script_self.KEY_PREFIX.'u='.
				(($value[4] == 'post')? $key: $value[1]).'">'.
				($value[2]? $value[2]: $value[1]).'</a>';
			$i++;
		}
		$content .= '</ol>';
	}
	$content = mb_convert_kana($content, $_kana_convopt);
	$content = trimContent($content, $local_args['s']);
} elseif ($local_args['a'] == 's') {
	$content = require_once 'Setup.inc.php';
	$content = mb_convert_kana($content, $_kana_convopt);
	$title = defined('SETUP_TITLE')? SETUP_TITLE: null;
} elseif ($local_args['a'] == 'l') {
	$content = require_once 'Auth.inc.php';
	$content = mb_convert_kana($content, $_kana_convopt);
	$title = defined('AUTH_TITLE')? AUTH_TITLE: null;
} elseif (($local_args['u'] === null or $local_args['u'] === '') and !$_raw_query) {
	if (defined('DEFAULT_URL') and DEFAULT_URL) {
		$_raw_query = DEFAULT_URL;
	} else {
		if (false === $content = @include_once 'Frontpage.inc.php') {
			$content = sayError('ERROR_FRONTPAGE_MISSING');
		} else {
			$content = mb_convert_kana($content, $_kana_convopt);
			$title = defined('DEFAULT_TITLE')? DEFAULT_TITLE: null;
		}
	}
}
if ($content === null) {
	require_once 'HTTP/Client.php';
	require_once 'HTTP/Request/Listener.php';
	class URL_Listener extends HTTP_Request_Listener {
		var $_url;
		var $_checkedUrl;
		var $_redirUrl;
		function update(&$subject, $event, $data) {
			switch ($event) {
				case 'httpSuccess':
				case 'httpError':
					if ('' == $this->_redirUrl) {
						$this->_url = $this->_checkedUrl;
					} else {
						$this->_url = $this->_redirUrl;
					}
					break;
				case 'httpRedirect':
					$this->_redirUrl = $data;
					break;
				case 'request':
					$this->_checkedUrl = $data;
					$this->_redirUrl = '';
			}
		}
		function getResults() {
			return $this->_url;
		}
	}
	$content = retrieveContent();
}
if (isset($_SESSION) and $remote_url and !$_is_error and !$_is_httperror and $_history_key !== null) {
	if (!isset($_SESSION['history'][$_history_key])) {
		$x = ($local_args['m'] == 'post' and strpos($remote_url, $local_args['u']) === 0);
		$_SESSION['history'][$_history_key] = array(
			time(),
			$remote_url,
			$title,
			$x? $_remote_args: null,
			$x? $local_args['m']: null,
			$x? $local_args['e']: null
		);
	} else {
		$_SESSION['history'][$_history_key][0] = time();
	}
}
if (isset($rss)) {
	$array = array_keys($rss);
	if (isset($array[0])) {
		$rss_url = $array[0];
	}
}
$title = mb_convert_kana($title, $_kana_convopt);
mb_convert_variables(OUTPUT_ENC, INT_ENC, $title);
mb_convert_variables(OUTPUT_ENC, INT_ENC, $content);
if (!defined('DEBUG_MODE') or !DEBUG_MODE) {
	require 'Template.inc.php';
} else {
	ob_start();
	require 'Template.inc.php';
	$_output_buffer = ob_get_contents();
	$_output_length = ob_get_length();
	ob_end_clean();
	$time_end = microtime_float();
	$elaps += ($time_end - $time_start);
	$time_start = $time_end;
	echo $_output_buffer.
		'<br>Length:'.number_format($_output_length).'bytes<br>
		Elapse:'.round($elaps, 2).'sec'.
		(function_exists('memory_get_usage')? '<br>Memory:'.number_format(memory_get_usage()).'bytes': null);
}
if (isset($_SESSION['authenticated'])) {
	$_session_save_path = realpath(session_save_path()).'/';
	$_session_filename = 'sess_'.session_id();
	$_backup_filename = 'pc2m_backup_'.$_SESSION['authenticated'];
	session_write_close();
	@copy($_session_save_path.$_session_filename, $_session_save_path.$_backup_filename);
}

/* -------------------------------------------------------------------------
	retrieveContent
------------------------------------------------------------------------- */

function retrieveContent() {

	global $remote_url;
	global $local_args;
	global $quick_search;
	global $new_image;
	global $_raw_query;
	global $_remote_args;
	global $_history_key;
	global $_is_error;
	global $_kana_convopt;
	$local_args['m'] = strtolower($local_args['m']);
	if (($local_args['m'] != null and $local_args['e'] == null)
		or ($local_args['e'] != null and $local_args['m'] == null)) {
		return sayError('ERROR_ARG_INVALID');
	}
	foreach ($local_args as $key => $value) {
		if ($value != null) {
			switch ($key) {
				case 'm':
					if (!preg_match('/^(?:post|get)$/', $value)) {
						return sayError('ERROR_ARG_INVALID');
					}
					break;
				case 'e':
					if (!preg_match('/^[\w-_\s]+$/', $value)) {
						return sayError('ERROR_ARG_INVALID');
					}
					break;
				case 'c':
					if (!preg_match('/^\d+$/', $value)) {
						$local_args['c'] = null;
					}
					break;
				case 'w':
					if (!preg_match('/^\d{1,3}$/', $value)) {
						$local_args['w'] = null;
					}
					break;
				case 'h':
					if (!preg_match('/^\d{1,3}$/', $value)) {
						$local_args['h'] = null;
					}
					break;
				case 't':
					if (!preg_match('/^[1-3]$/', $value)) {
						$local_args['t'] = null;
					}
					break;
				case 'q':
					if (!preg_match('/^\d{1,3}[^\d\s]*$/', $value)) {
						$local_args['q'] = null;
					}
					break;
			}
		}
	}
	if (preg_match('/^[0-9a-f]{32}$/', $local_args['u'])) {
		if (isset($_SESSION['history'][$local_args['u']])) {
			if ($local_args['o'] === null) {
				return sayError('ERROR_CONFIRM_POST');
			}
			if ($local_args['o'] == '1') {
				$_remote_args = $_SESSION['history'][$local_args['u']][3];
			}
			$local_args['m'] = $_SESSION['history'][$local_args['u']][4];
			$local_args['e'] = $_SESSION['history'][$local_args['u']][5];
			$local_args['u'] = $_SESSION['history'][$local_args['u']][1];
			$_raw_query =& $local_args['u'];
		} else {
			return sayError('ERROR_NOHISTORY');
		}
	}
	$_post_data = array();
	if ($local_args['m'] != null and $local_args['e'] != null) {
		if (!$local_args['u']) {
			return sayError('ERROR_URL_EMPTY');
		} else {
			$_url = $local_args['u'];
		}
		mb_convert_variables($local_args['e'], OUTPUT_ENC, $_remote_args);
		if ($local_args['m'] == 'post') {
			foreach ($_remote_args as $key => $value) {
				$key = str_replace('x2E', '.', $key);
				if (preg_match('/^(.*)x78x79$/', $key, $matches)) {
					if ($matches[1] !== '') {
						$_post_data[$matches[1].'.x'] = '0';
						$_post_data[$matches[1].'.y'] = '0';
						$_post_data[$matches[1]] = $value;
					} else {
						$_post_data['x'] = '0';
						$_post_data['y'] = '0';
					}
				} else {
					$_post_data[$key] = $value;
				}
			}
		} else {
			$_net_url =& new Net_URL($_url);
			foreach ($_remote_args as $key => $value) {
				$key = str_replace('x2E', '.', $key);
				if (is_array($value)) {
					$_net_url->addQueryString($key, $value);
				} elseif (preg_match('/^(.*)x78x79$/', $key, $matches)) {
					if ($matches[1] !== '') {
						$_net_url->addQueryString($matches[1].'.x', '0');
						$_net_url->addQueryString($matches[1].'.y', '0');
						$_net_url->addQueryString($matches[1], $value);
					} else {
						$_net_url->addQueryString('x', '0');
						$_net_url->addQueryString('y', '0');
					}
				} else {
					$_net_url->addQueryString($key, $value);
				}
			}
			$_url = $_net_url->getURL();
		}
	} else {
		if (strpos($_raw_query, '?') === false
			and (preg_match('/%3A/i', $_raw_query)
				or preg_match('/%2E/i', $_raw_query)
				or preg_match('/%2F/i', $_raw_query))) {
			$_raw_query = urldecode($_raw_query);
		}
		$_raw_query = str_replace('&amp;', '&', $_raw_query);
		if (preg_match('/^(\w+):\/*?(\w.+)/', $_raw_query, $matches)) {
			if (!preg_match('/^https?/', $matches[1])) {
				return sayError('ERROR_SCHEME_UNSUPPORTED', $matches[1]);
			} elseif ($matches[1] == 'https'
				and (!defined('SSL_ENABLED') or !SSL_ENABLED)) {
				return sayError('ERROR_SSL_DISABLED', $_raw_query);
			} else {
				$_url = $matches[1].'://'.$matches[2];
			}
		} elseif (preg_match('/^[\w-]+\.[\w-]+/', $_raw_query)) {
				$_url = 'http://'.$_raw_query;
		} else {
			$_raw_query = mb_convert_kana(mb_convert_encoding(urldecode($_raw_query), INT_ENC, OUTPUT_ENC), 'asKHV');
			if (defined('QUICK_SEARCH')) {
				if (preg_match('/^\s*(\w+)\s+(.*)$/', $_raw_query, $matches)) {
					$_search_key = strtolower($matches[1]);
					$_search_string = $matches[2];
				}
				if (!isset($_search_key) or !isset($quick_search[$_search_key])) {
					$_search_key = QUICK_SEARCH;
					$_search_string = $_raw_query;
				}
				$_url = $quick_search[$_search_key][0].
					urlencode(mb_convert_encoding($_search_string, $quick_search[$_search_key][1], INT_ENC));
			} else {
				return sayError('ERROR_URL_INVALID', $_raw_query);
			}
		}
	}
	$_url = str_replace("\x20", '%20', $_url);
	$array = parse_url($_url);
	if ((
			$array['host'] == $_SERVER['HTTP_HOST']
			or (
				isset($array['port'])
				and $array['host'].':'.$array['port'] == $_SERVER['HTTP_HOST']
			)
		) and (
			$array['path'] == $_SERVER['SCRIPT_NAME']
			or $array['path'] == dirname($_SERVER['SCRIPT_NAME'])
			or $array['path'] == dirname($_SERVER['SCRIPT_NAME']).'/'
		)) {
		header('Location:'.$_url);
		exit;
	}
	$_content = sendRequest($_url, array(), $_post_data);
	if ($new_image or $_is_error) {
		return $_content;
	}
	if (preg_match_all('/<frame\b[^>]*?>/si', $_content, $matches)) {
		$_content = sendRequest(getAttribute('src', $matches[0][0]), array(), array(), true);
		for ($i = 1; $i < count($matches[0]); $i++) {
			$_content .= '<hr>'.sendRequest(getAttribute('src', $matches[0][$i]), array(), array(), true);
		}
	}
	$_content = mb_convert_kana($_content, $_kana_convopt);

/* You may place an additional code here
 * to modify the "converted" HTML source
 */

	$_history_key = $remote_url;
	if ($local_args['m'] == 'post'
		and $remote_url == $local_args['u']) {
		$_net_url =& new Net_URL($remote_url);
		foreach ($_remote_args as $key => $value) {
			$key = str_replace('x2E', '.', $key);
			if (is_array($value)) {
				$_net_url->addQueryString($key, $value);
			} else {
				$_net_url->addQueryString($key, $value);
			}
		}
		$_history_key = $_net_url->getURL();
	}
	$_history_key = md5($_history_key);
	if (false !== $_trim_from = mb_strpos($_content, '<fragment>')) {
		$_content = str_replace('<fragment>', null, $_content);
	} else {
		$_trim_from = 0;
	}
	if ($local_args['s'] != null) {
		if (!is_numeric($local_args['s']) or $local_args['s'] < 0) {
			$x = $local_args['s'];
			$x = preg_quote($x);
			$x = str_replace("'", "\'", $x);
			$search = "'".mb_convert_kana($x, $_kana_convopt)."'si";
			if (preg_match($search, $_content, $matches, PREG_OFFSET_CAPTURE)) {
				if (substr($_content, $matches[0][1] -1, 1) == '>') {
					$_trim_from = mb_strlen(substr($_content, 0, $matches[0][1] -1));
				} else {
					$_trim_from = mb_strlen(substr($_content, 0, $matches[0][1]));
				}
			} else {
				return sayError('ERROR_WORD_NOTFOUND', htmlspecialchars($local_args['s']));
			}
		} else {
			$_trim_from = $local_args['s'];
		}
	}
	return trimContent($_content, $_trim_from);
}

/* -------------------------------------------------------------------------
	sendRequest
------------------------------------------------------------------------- */

function sendRequest($_url, $_client_param = array(), $_post_data = array(), $_is_framesrc = false, $_referer = null) {

	global $client;
	global $remote_url;
	global $local_args;
	global $new_image;
	global $image_quality;
	global $mime_types;
	global $_current_url;
	global $_remote_charset;
	global $_is_httperror;
	$_remote_charset = null;
	if (isset($_SESSION)
		and $local_args['i'] !== null
		and $local_args['p'] !== null
		and $local_args['r'] !== null) {
		extract(parse_url($_url));
		$_SESSION['www_authenticate'][md5($host.$local_args['r'])] = array(
			'path' => getDirName($path),
			'user' => $local_args['i'],
			'pass' => $local_args['p']
		);
	}
	$_http_client =& new HTTP_Client(
		$_client_param,
		array(
			'Accept-Charset' => 'Shift_JIS,utf-8,*',
			'Accept-Language' => 'ja',
		)
	);
	$_http_client->attach($_url_listener =& new URL_Listener());
	if (defined('PEAR_USER_AGENT') and PEAR_USER_AGENT) {
		$_http_client->setDefaultHeader('User-Agent', PEAR_USER_AGENT);
	}
	if (isset($_SESSION['cookies'])) {
		foreach ($_SESSION['cookies'] as $key => $value) {
			$_http_client->_cookieManager->addCookie($value);
		}
	}
	if ($_referer !== null) {
		$_http_client->setDefaultHeader('Referer', $_referer);
	} else {
		if (isset($_SESSION['history'])) {
			$array = sortMultiArray($_SESSION['history'], 0);
			foreach ($array as $key => $value) {
				if ($value[1] != $_url) {
					$_http_client->setDefaultHeader('Referer', $value[1]);
					break;
				}
			}
		}
	}
	if (isset($_SESSION)) {
		session_write_close();
	}
	if (defined('DEBUG_MODE') and DEBUG_MODE) {
		global $elaps;
		global $time_start;
		$time_end = microtime_float();
		$elaps += ($time_end - $time_start);
	}
	if (!empty($_post_data)) {
		$_http_client->post($_url, $_post_data);
	} else {
		$_http_client->get($_url);
	}
	if (defined('DEBUG_MODE') and DEBUG_MODE) {
		global $time_start;
		$time_start = microtime_float();
	}
	if (isset($_SESSION)) {
		session_start();
	}
	if (null === $_response =& $_http_client->currentResponse()) {
		if (!$_is_framesrc) {
			$remote_url = $_url;
		}
		return sayError('ERROR_SERVER_NORESPONSE', $_url);
	}
	if (isset($_SESSION)
		and 0 === strpos($_response['code'], '401')
		and preg_match('/^Basic\srealm="(.*)"$/i', $_response['headers']['www-authenticate'], $matches)) {
		$_realm = $matches[1];
		extract(parse_url($_url));
		$x = md5($host.$_realm);
		if (!isset($_client_param['user'])
			and !isset($_client_param['user'])
			and isset($_SESSION['www_authenticate'][$x]['user'])
			and isset($_SESSION['www_authenticate'][$x]['pass'])
			and isset($_SESSION['www_authenticate'][$x]['path'])
			and strpos(getDirName($path), $_SESSION['www_authenticate'][$x]['path']) === 0) {
			$_client_param['user'] = $_SESSION['www_authenticate'][$x]['user'];
			$_client_param['pass'] = $_SESSION['www_authenticate'][$x]['pass'];
			return sendRequest($_url, $_client_param, $_post_data, $_is_framesrc);
		} elseif (SHOW_PASSINPUT) {
			if (!$_is_framesrc) {
				$remote_url = $_url;
			}
			return sayError('ERROR_AUTH_REQUIRED', $host, $_realm);
		}
	}
	$_current_url = parse_url($_url_listener->getResults());
	$_current_url['url'] = $_url_listener->getResults();
	if (0 === strpos($_current_url['url'], 'http://www.google.co.jp/accounts/SetSID?')) {
		global $script_self;
		header('Location:'.$script_self.KEY_PREFIX.'u='.$_current_url['url']);
		exit;
	}
	if (!$_is_framesrc) {
		$remote_url = $_current_url['url'];
	}
	$_is_httperror = ($_response['code'] != '200');
	if (isset($_current_url['fragment'])) {
		$local_args['f'] = $_current_url['fragment'];
	}
	if (isset($_SESSION)) {
		foreach ($_http_client->_cookieManager->_cookies as $key => $value) {
			$_SESSION['cookies'][$key] = $value;
		}
	}
	if (isset($mime_types) and isset($_current_url['path'])) {
		$x = preg_replace('/^.+\.(\w+)$/', '$1', basename(strtolower($_current_url['path'])));
		if (isset($mime_types[$x])) {
			$_response['headers']['content-type'] = $mime_types[$x];
		}
	}
	if (isset($_response['headers']['content-type'])) {
		preg_match('/^([a-z\/\.\+\-]+)(.*)$/', $_response['headers']['content-type'], $matches);
	}
	switch ($_ctype = isset($matches[1])? $matches[1]: null) {
		case null:
		case 'text/html':
		case 'text/xhtml';
		case 'application/xhtml+xml':
			if (isset($matches[2]) and preg_match('/^.*\bcharset\s*=\s*(.+)$/', $matches[2], $matches)) {
				$_remote_charset = checkCharset($matches[1]);
			}
			return convertHTML($_response['body'], $_is_framesrc);
			break;
		case 'image/gif':
		case 'image/jpeg':
		case 'image/pjpeg':
		case 'image/png':
			if (!IMAGE_CONVERTER) {
				return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
			}
			if (isset($_response['headers']['content-length'])
				and is_numeric($_response['headers']['content-length'])
				and (int) $_response['headers']['content-length'] > ALLOWABLE_CLENGTH) {
				if (!$_is_framesrc) {
					$remote_url = $_url_listener->getResults();
				}
				return sayError('ERROR_CLENGTH_EXCEEDED',
					$_url_listener->getResults(),
					number_format($_response['headers']['content-length']),
					number_format(ALLOWABLE_CLENGTH));
			}
			if ($_is_framesrc) {
				return $local_args["v"]?
					'<img src="'.addImageProxyURL($_current_url['url']).'">':
					'['.mb_strimwidth(getFilename($_current_url['url']), 0, 11, "...").
						'<a href="'.addProxyURL($_current_url['url']).'">+</a>]';
			}
			if ($client->screen['color'] < 256) {
				return sayError('ERROR_COLOR_INCAPABLE');
			}
			if (false === $_resource = @imageCreateFromString($_response['body'])) {
				return sayError('ERROR_ISNOT_IMAGE', $_current_url['url']);
			}
			$_width = imageSx($_resource);
			$_height = imageSy($_resource);
			switch ($_ctype) {
				case 'image/gif';
					$_type = 1;
					break;
				case 'image/png':
					$_type = 3;
					break;
				default:
					$_type = 2;
			}
			$new_image = getNewImageInfo(array($_width, $_height, $_type));
			$image_quality = $new_image[3];
			if ($local_args['a'] == 'i') {
				transcodeImage($_resource, array($_width, $_height, $_type));
			} else {
				return '<img src="'.addImageProxyURL($_current_url['url']).'">';
			}
			break;
		case 'application/xml':
		case 'application/rdf+xml':
		case 'application/rss+xml':
		case 'text/xml':
			if (defined('RSS_ENABLED') and RSS_ENABLED === true) {
				return convertRSS($_response['body']);
			} else {
				return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
			}
			break;
		case 'text/plain':
			if (preg_match('/^\s*?<\?xml\b[^>]+?>\s*?<(?:rdf\:|rss\s|feed\s)[^>]+?>/si', $_response['body'])) {
				if (defined('RSS_ENABLED') and RSS_ENABLED === true) {
					return convertRSS($_response['body']);
				} else {
					return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
				}
			} else {
				$_response['body'] = str_replace("\x0", null, $_response['body']);
				$_response['body'] = preg_replace('/^\xef\xbb\xbf/', null , $_response['body']);
				return nl2br(htmlspecialchars(@mb_convert_encoding($_response['body'], INT_ENC, 'auto')));
			}
			break;
		default:
			return sayError('ERROR_CTYPE_INVALID', $_current_url['url'], $_ctype);
	}
}

/* -------------------------------------------------------------------------
	convertRSS
------------------------------------------------------------------------- */

function convertRSS($_content) {

	global $remote_url;
	global $title;
	global $_remote_charset;
	if (empty($_content)) {
		return sayError('ERROR_CONTENT_EMPTY');
	}
	$_content = str_replace("\x0", null, $_content);
	$_content = preg_replace('/^\xef\xbb\xbf/', null , $_content);
	if (preg_match('/<\?xml\b[^>]+?\?>/si', $_content, $matches)) {
		$_xml_encoding = checkCharset(getAttribute('encoding', $matches[0]));
		$replace = '<?xml version="'.getAttribute('version', $matches[0]).'" encoding="UTF-8"?>';
		$_content = str_replace($matches[0], $replace, $_content);
	} else {
		$_content = '<?xml version="1.0" encoding="UTF-8"?>'.$_content;
	}
	if (!isset($_xml_encoding)) {
		$_xml_encoding = @mb_detect_encoding($_content);
	}
	mb_convert_variables('UTF-8', $_xml_encoding, $_content);
	require_once 'XML/RSS.php';
	$_xml_rss =& new XML_RSS();
	$_xml_rss->setInputString($_content);
	if (PEAR::isError($_result = $_xml_rss->parse())) {
		$array = get_object_vars($_result);
		return sayError('ERROR_XML_PARSEFAILED', $remote_url, $array['message']);
	}
	if (!$_channel_info = $_xml_rss->getChannelInfo()) {
		return sayError('ERROR_RSS_INVALID', $remote_url);
	}
	$title = mb_convert_encoding($_channel_info['title'], INT_ENC, 'UTF-8');
	$_content = '<p><a href="'.$_channel_info['link'].'">'.
		$_channel_info['title'].'</a>'.
			(isset($_channel_info['description'])? '<br>'.$_channel_info['description'].'</p>': '</p>');
	foreach ($_xml_rss->getItems() as $_item) {
		$_content .= '<p><a href="'.$_item['link'].'">'.$_item['title'].'</a>';
		if (isset($_item['dc:date'])) {
			$_time =& $_item['dc:date'];
		} elseif (isset($_item['pubdate'])) {
			$_time =& $_item['pubdate'];
		}
		if (isset($_time)) {
			if (-1 != $_unixtime = strtotime($_time)) {
				$_content .= '<br>'.date('Y/m/d H:i:s', $_unixtime).'</p>';
			} else {
				$_content .= '<br>'.$_time.'</p>';
			}
		} else {
			$_content .= '</p>';
		}
		if (isset($_item['content:encoded'])) {
			$_content .= '<p>'.$_item['content:encoded'].'</p>';
		} elseif (isset($_item['description'])) {
			$_content .= '<p>'.$_item['description'].'</p>';
		}
	}
	$_remote_charset = 'UTF-8';
	return convertHTML($_content);
}

/* -------------------------------------------------------------------------
	convertHTML
------------------------------------------------------------------------- */

function convertHTML($_content, $_is_framesrc = false) {

	global $remote_url;
	global $rss_url;
	global $rss;
	global $mobile_url;
	global $title;
	global $local_args;
	global $force_trim;
	global $body_elements;
	global $_current_url;
	global $_remote_charset;
	global $_base_href;
	global $_refresh_count;
	global $_is_error;
	global $_is_httperror;
	global $_kana_convopt;
	if (empty($_content)) {
		return sayError('ERROR_CONTENT_EMPTY');
	}
	$_content = str_replace("\x0", null, $_content);
	$_content = preg_replace('/^\xef\xbb\xbf/', null , $_content);

/* If you want to show users the URLs mentioned in JavaScript codes of the page,
 * remove the comment marks from the following lines (and follow other notes as well).
 * Following lines will backup the content of each SCRIPT element in a variable
 * from which the URLs will be extracted at the very last section of this function.
 */

/*
 *  if (preg_match_all('/<script\b[^>]*?>(.+?)<\/script\b[^>]*?>/si', $_content, $matches)) {
 *      $_js = implode("\x20", $matches[1]);
 *  }
 */

	if (preg_match('/<head\b.+?<\/head\b[^>]*?>/si', $_content, $matches)) {
		$x = preg_replace('/<!--.*?-->/si', null, $matches[0]);
		$x = preg_replace('/<script\b.+?<\/script\b[^>]*?>/si', null, $x);
		$_content = str_replace($matches[0], $x, $_content);
	}
	$_base_href = null;
	if (preg_match('/<base\b[^>]*?>/si', $_content, $matches)) {
		$_base_href = transAbsolutePath(getAttribute('href', $matches[0]));
	}
	foreach (getTagLines('meta', $_content) as $_node) {
		switch (strtolower(getAttribute('http-equiv', $_node))) {
			case 'refresh':
				if (preg_match('/\s*\d+\s*;\s*(.+)/si', getAttribute('content', $_node), $matches)) {
					$_url = preg_replace('/^url\s*=\s*(.+)$/si', '$1', $matches[1]);
					$_url = removeQuote(preg_replace('/^&quot;\s*(.+)\s*&quot;$/si', '$1', $_url));
					if (!empty($_url)) {
						$_url = transAbsolutePath($_url);
						if (preg_match('/^http/i', $_url)
							and $_current_url['url'] != $_url
							and $_refresh_count < MAX_META_REDIRECT) {
							$_refresh_count++;
							return sendRequest($_url, array(), array(), $_is_framesrc, $_current_url['url']);
						}
					}
				}
				break;
			case 'content-type':
				if ($_remote_charset === null) {
					$array = explode(';', getAttribute('content', $_node));
					if (isset($array[1]) and preg_match('/.*\bcharset\b\s*=\s*(.+)/si', $array[1], $matches)) {
						$_remote_charset = checkCharset($matches[1]);
					}
				}
				break;
		}
		$_content = str_replace($_node, null, $_content);
	}
	if ($_remote_charset === null) {
		$_remote_charset = @mb_detect_encoding($_content);
	}
	mb_convert_variables(INT_ENC, $_remote_charset, $_content);
	$_content = mb_decode_numericentity(
		preg_replace('/&#x([0-9a-fA-F]+);/e', '"&#".hexdec("\\1").";"', $_content),
		array(0x0021, 0x007E, 0x0000, 0xFFFF)
	);
	$search = null;
	if ($local_args['f'] !== null) {
		$_fragment = preg_quote($local_args['f']);
		$_fragment = str_replace("'", "\'", $_fragment);
		$_id_search = true;
	} elseif (defined('FORCE_TRIM') and FORCE_TRIM === true) {
		foreach ($force_trim as $key => $value) {
			if (strpos(strtolower($remote_url), strtolower($key))) {
				$_fragment = is_array($value[0])? '(?:'.implode('|', $value[0]).')': $value[0];
				$_id_search = $value[1]? true: false;
				break;
			}
		}
	}
	if (isset($_fragment)) {
		if ($_id_search) {
			$search = "'^(.*?)(<\w+\b[^>]*?\b(?:name|id)\s*?=\s*?[\'\"]?".$_fragment."[\'\"\s>].*)$'si";
		} else {
			$search = "'^(.*?)(".$_fragment.".*)$'s";
		}
		if (preg_match($search, $_content, $matches)) {
			$_content = $matches[1].'<fragment>'.$matches[2];
		}
	}

/* You may place an additional code here
 * to modify the "original" HTML source
 */

	$_remains = array();
	$search = array();
	$replace = array();
	if (preg_match_all('/<!--pc2m_remain-->(.+?)<!--\/pc2m_remain-->/si', $_content, $matches)) {
		for ($i = 0; $i < count($matches[0]); $i++) {
			$_remains[] = $matches[1][$i];
			$search[] = $matches[0][$i];
			$replace[] = '<untouch_'.(count($_remains) -1).'>';
		}
	}
	if (preg_match_all('/(<textarea\b[^>]*?>)(.*?)<\/textarea\b[^>]*?>/si', $_content, $matches)) {
		for ($i = 0; $i < count($matches[0]); $i++) {
			$_name = str_replace('.', 'x2E', getAttribute('name', $matches[1][$i]));
			$_remains[] = '<textarea'.($_name? ' name="'.$_name.'"': null).'>'.$matches[2][$i].'</textarea>';
			$search[] = $matches[0][$i];
			$replace[] = '<untouch_'.(count($_remains) -1).'>';
		}
	}
	if ($replace) {
		$_content = str_replace($search, $replace, $_content);
	}
	$_content = mb_convert_kana($_content, 's');
	$_content = preg_replace('/<!--pc2m_void-->.+?<!--\/pc2m_void-->/si', null, $_content);
	$_content = preg_replace('/<!--.*?-->/si', null, $_content);
	$_content = preg_replace('/<script\b.+?<\/script\b[^>]*?>/si', null, $_content);
	$_content = preg_replace('/<style\b.+?<\/style\b[^>]*?>/si', null, $_content);
	$_content = preg_replace('/<iframe\b.+?<\/iframe\b[^>]*?>/si', null, $_content);
	$_content = preg_replace('/<noframes?\b.+?<\/noframes?\b[^>]*?>/si', null, $_content);
	if (!$_is_framesrc
		and preg_match_all('/<title\b[^>]*?>(.*?)<\/title\b[^>]*?>/si', $_content, $matches)) {
		for ($i = 0; $i < count($matches[0]); $i++) {
			$matches[1][$i] = replaceChars(preg_replace('/(?:\r\n|\n)/', null, $matches[1][$i]));
			if ($matches[1][$i] !== '') {
				$title = mb_strimwidth($matches[1][$i], 0, 64, '...');
				if ($_is_httperror) {
					$_content = $title.'<hr>'.$_content;
				}
				break;
			}
		}
	}
	$_content = preg_replace('/<title\b.+?<\/title\b[^>]*?>/si', null, $_content);
	if (!$_is_framesrc) {
		if (preg_match_all('/<frame\b[^>]*?>/si', $_content, $matches)) {
			$x = null;
			for ($i = 0; $i < count($matches[0]); $i++) {
				if (null !== $_url = getAttribute("src", $matches[0][$i])) {
					$x .= '<frame src="'.transAbsolutePath($_url).'">';
				}
			}
			if ($x !== null) {
				$_content =& $x;
				return $_content;
			}
		}
	}
	foreach (getTagLines('link', $_content) as $_node) {
		if (strtolower(getAttribute('rel', $_node)) == 'alternate') {
			if (defined('RSS_ENABLED') and RSS_ENABLED === true
				and preg_match('/^application\/(?:rss\+|rdf\+)?xml$/', getAttribute('type', $_node))) {
				if (null !== $_url = getAttribute('href', $_node)) {
					$_url = transAbsolutePath($_url);
					if (null === $_title = getAttribute('title', $_node)) {
						$_title = getFilename($_url);
					}
					$_url = addProxyURL($_url);
					if (!isset($rss[$_url])) {
						mb_convert_variables(OUTPUT_ENC, INT_ENC, $_title);
						$rss[$_url] = mb_convert_kana($_title, $_kana_convopt, OUTPUT_ENC);
					}
				}
			}
			if (strtolower(getAttribute('media', $_node)) == 'handheld') {
				if (null !== $_url = getAttribute('href', $_node)) {
					$mobile_url = transAbsolutePath($_url);
				}
			}
		}
		$_content = str_replace($_node, null, $_content);
	}
	$_content = preg_replace_callback(
		'/<pre\b[^>]*?>(.+?)<\/pre\b[^>]*?>/si',
		create_function('$matches', '
			return "<p>".nl2br(trim($matches[1]))."</p>";
		'), $_content);
	$_content = preg_replace_callback(
		'/<plaintext\b[^>]*?>(.+?)<\/plaintext\b[^>]*?>/si',
		create_function('$matches', '
			return "<p>".nl2br(htmlspecialchars(trim($matches[1])))."</p>";
		'), $_content);
	if (!$_is_framesrc and $local_args['a'] != 'c' and $local_args['l']) {
		if (preg_match_all('/<body\b[^>]+?>/si', $_content, $matches)) {
			$x = $matches[0][count($matches[0]) -1];
			$body_elements['background'] = null;
			if ($local_args['v'] and null !== $body_elements['background'] = getAttribute('background', $x)) {
				$body_elements['background'] = addImageProxyURL(transAbsolutePath($body_elements['background']));
			}
			$body_elements['bgcolor'] = getAttribute('bgcolor', $x);
			if ($body_elements['bgcolor']) {
				$body_elements['bgcolor'] = strtolower($body_elements['bgcolor']);
			}
			$body_elements['text'] = getAttribute('text', $x);
			if ($body_elements['text']) {
				$body_elements['text'] = strtolower($body_elements['text']);
			}
			$body_elements['link'] = getAttribute('link', $x);
			if ($body_elements['link']) {
				$body_elements['link'] = strtolower($body_elements['link']);
			}
			$body_elements['alink'] = getAttribute('alink', $x);
			if ($body_elements['alink']) {
				$body_elements['alink'] = strtolower($body_elements['alink']);
			}
			$body_elements['vlink'] = getAttribute('vlink', $x);
			if ($body_elements['vlink']) {
				$body_elements['vlink'] = strtolower($body_elements['vlink']);
			}
			if ($body_elements['background'] === null) {
				if ($body_elements['bgcolor']) {
					if ($body_elements['bgcolor'] == $body_elements['text']
						or $body_elements['text'] === null) {
						if ($body_elements["bgcolor"] != "#000000"
							and $body_elements["bgcolor"] != "black") {
							$body_elements['text'] = null;
						} else {
							$body_elements['text'] = '#ffffff';
						}
					}
					if ($body_elements['bgcolor'] == $body_elements['link']) {
						$body_elements['link'] = null;
					}
					if ($body_elements['bgcolor'] == $body_elements['vlink']) {
						$body_elements['vlink'] = null;
					}
				} elseif ($body_elements['text'] == "#ffffff" or $body_elements['text'] == "white") {
					$body_elements['text'] = null;
				}
			}
			if ($body_elements['link'] == $body_elements['alink']) {
				$body_elements['alink'] = null;
			}
		}
	}
	if ($local_args['a'] == 'c') {
		$array = array(
			'fragment'
		);
	} else {
		$array = array(
			'fragment', 'untouch_\d+', 'frame',  'br', 'hr',
			'p', 'div', 'h[1-6]', 'address', 'dl', 'dt', 'dd',
			'blockquote', 'ul', 'ol', 'li', 'table', 'tr', 'th', 'td',
			'form', 'input', 'option', 'select', 'textarea', 'label',
			'a', 'img', 'image', 'object', 'param', 'embed', 'area',
		);
	}
	if ($local_args['a'] != 'c' and $local_args['l']) {
		array_push($array, 'font', 'small', 'big', 'b', 'strong', 'i', 'em', 'u', 'blink', 'marquee');
	}
	$search = "'<(?!\/?".implode('\b|\/?', $array)."\b)(?:\?|!\[|!|\/)?[a-z][^>]*?>'si";
	$_content = preg_replace($search, null, $_content);
	if ($local_args['a'] == 'c') {
		$_content = replaceChars($_content);
		$_content = preg_replace(
			array(
				"'[\r\n]'",
				"'\x20{2,}'",
				"'\t'"
			),
			array(
				null,
				"\x20",
				null
			),
		$_content);
		$_buff = '<form action="'.basename($_SERVER['SCRIPT_NAME']).'">';
		$i = 0;
		while ($i < mb_strlen($_content)) {
			$_trimmed_segment = mb_strimwidth($_content, $i, 200, null);
			$_buff .= '<textarea>'.$_trimmed_segment.'</textarea>';
			$i += mb_strlen($_trimmed_segment);
		}
		$_buff .= '</form>';
		return $_buff;
	}
	if (!$local_args['l']) {
		$_content = preg_replace('/<(br|hr|p|dl|dt|dd|ul|ol|li)\b[^>]*?>/si', '<$1>', $_content);
	} else {
		$_content = preg_replace('/<(br)\b[^>]*?>/si', '<$1>', $_content);
	}
	if (!$local_args['l']) {
		$search = "'([\s\'\"])\b(?:align|style|class|id|autocomplete|border|cols|dir|face|lang|rows|tabindex|target|wrap|on(?!click)[^\s=]+?)".
			"\b\s*=\s*(?!&quot;)(?:[^\s\'\">]+|\'[^\']+\'|\"[^\"]+\")'si";
	} else {
		$search = "'([\s\'\"])\b(?:style|class|id|autocomplete|border|cols|dir|face|lang|rows|tabindex|target|wrap|on(?!click)[^\s=]+?)".
			"\b\s*=\s*(?!&quot;)(?:[^\s\'\">]+|\'[^\']+\'|\"[^\"]+\")'si";
	}
	$_content = preg_replace($search, '$1', $_content);
	$_content = preg_replace('/<(\/?\w+)\s*?>/s', '<$1>', $_content);
	if ($local_args['l']) {
		$_content = preg_replace_callback(
			'/<font\b[^>]*?>/si',
			create_function('$matches', '
				global $body_elements;
				$_size = strtolower(getAttribute("size", $matches[0]));
				$_color = strtolower(getAttribute("color", $matches[0]));
				if (!isset($body_elements["background"])) {
					if (isset($body_elements["bgcolor"])) {
						if ($body_elements["bgcolor"] == $_color) {
							if ($body_elements["bgcolor"] != "#000000"
								and $body_elements["bgcolor"] != "black") {
								$_color = null;
							} else {
								$_color = "#ffffff";
							}
						}
					} elseif ($_color == "#ffffff" or $_color == "white") {
						$_color = null;
					}
				}
				return "<font".
					($_size? " size=\"".$_size."\"": null).
					($_color? " color=\"".$_color."\"": null).
					">";
			'), $_content);
	}
	if (defined('CONVERT_INDENT_TAGS') and CONVERT_INDENT_TAGS) {
		$search = array(
			"'<(\/?)(?:dl|dt|dd)[^>]*?>'si",
			"'<\/?blockquote[^>]*?>'si",
		);
		$replace = array(
			"<\\1p>",
			"<hr>",
		);
		$_content = preg_replace($search, $replace, $_content);
	} else {
		$_content = preg_replace_callback(
			'/(<dt\b[^>]*?>)(.*?)(<\/?(?:d[ltd])\b[^>]*?>)/si',
			create_function('$matches', '
				return !preg_match("/<\/dt\b[^>]*?>/si", $matches[2])?
					$matches[1].$matches[2]."</dt>".$matches[3]: $matches[0];
			'), $_content);
		$_content = preg_replace_callback(
			'/(<dd\b[^>]*?>)(.*?)(<\/?(?:d[ltd])\b[^>]*?>)/si',
			create_function('$matches', '
				return !preg_match("/<\/dd\b[^>]*?>/si", $matches[2])?
					$matches[1].$matches[2]."</dd>".$matches[3]: $matches[0];
			'), $_content);
	}

/* If a TD tag has a background attibute,
 * following preg_replace_callback will insert an IMG tag right after the TD.
 * This will make the background image visible as an normal image.
 * while leaving the lines commented out will simply disregard it.
 */

/*
 *  $_content = preg_replace_callback(
 *      '/<t[hd]\b[^>]*?>/si',
 *      create_function('$matches', '
 *          $_background = getAttribute("background", $matches[0]);
 *          return $_background? $matches[0]."<img src=\"".$_background."\">": $matches[0];
 *      '), $_content);
 */

	$_content = preg_replace_callback(
		'/<td\b[^>]*?>(.*?)<\/td\b[^>]*?>/si',
		create_function('$matches', '
			$_b = preg_match("/<b\b[^>]*?>/si", $matches[1]) and !preg_match("/<\/b\b[^>]*?>/si", $matches[1]);
			$_font = preg_match("/<font\b[^>]*?>/si", $matches[1]) and !preg_match("/<\/font\b[^>]*?>/si", $matches[1]);
			$_a = preg_match("/<a\b[^>]*?>/si", $matches[1]) and !preg_match("/<\/a\b[^>]*?>/si", $matches[1]);
			return "<td>".$matches[1].
				($_a? "</a>": null).
				($_b? "</b>": null).
				($_font? "</font>": null).
				"</td>";
		'), $_content);
	$_content = preg_replace_callback(
		'/<th\b[^>]*?>(.*?)<\/th\b[^>]*?>/si',
		create_function('$matches', '
			$_b = preg_match("/<b\b[^>]*?>/si", $matches[1]) and !preg_match("/<\/b\b[^>]*?>/si", $matches[1]);
			$_font = preg_match("/<font\b[^>]*?>/si", $matches[1]) and !preg_match("/<\/font\b[^>]*?>/si", $matches[1]);
			$_a = preg_match("/<a\b[^>]*?>/si", $matches[1]) and !preg_match("/<\/a\b[^>]*?>/si", $matches[1]);
			return "<th>".$matches[1].
				($_a? "</a>": null).
				($_b? "</b>": null).
				($_font? "</font>": null).
				"</th>";
		'), $_content);
	$_content = preg_replace('/(<a\b[^>]*?>)/si', '</a>$1', $_content);
	$_tag_begin = @mb_strrpos(strtolower($_content), '<a ');
	$_tag_end = @mb_strrpos(strtolower($_content), '</a>');
	if ($_tag_begin !== false
		and ($_tag_end  === false or $_tag_begin > $_tag_end)) {
		$_content = $_content.'</a>';
	}
	if (!$local_args['l']) {
		$search = array(
			"'<(\/?)(?:div|h[1-6]|address)\b[^>]*?>'si",
			"'<\/embed\b[^>]*?>'si",
		);
		$replace = array(
			"<\\1p>",
			null,
		);
	} else {
		$search = array(
			"'<(\/?)(?:div|h[1-6]|address)\b([^>]*?)>'si",
			"'<\/embed\b[^>]*?>'si",
		);
		$replace = array(
			"<\\1p\\2>",
			null,
		);
	}
	$_content = preg_replace($search, $replace, $_content);
	$search = array(
		"'(<li\b([^>]*?)>)\s*?<p\b([^>]*?)>'si",
		"'<\/p\b([^>]*?)>\s*?(<\/li\b([^>]*?)>)'si",
	);
	$replace = array(
		"\\1",
		"\\1",
	);
	$_content = preg_replace($search, $replace, $_content);
	$_content = preg_replace_callback(
		'/(<a\b[^>]+?>)(.*?)<\/a\b[^>]*?>/si',
		create_function('$matches', '
			global $client;
			global $local_args;
			if (preg_match("/^\s*$/s", $matches[2])) {
				return null;
			}
			if ("#" == $_link_url = getAttribute("href", $matches[1])) {
				if ($array = extractURLfromJS(getAttribute("onclick", $matches[1]))) {
					$_link_url = $array[0];
				} else {
					$_link_url = null;
				}
			}
			if ($_link_url) {
				$_link_url = transAbsolutePath($_link_url);
				$_accesskey = getAttribute("accesskey", $matches[1]);
				$_title = getAttribute("title", $matches[1]);
			}
			$_valid_url = preg_match("/^(?:https?|mailto|tel)/", $_link_url);
			$_link = $_valid_url?
				"<a href=\"".addProxyURL($_link_url)."\"".
				($_accesskey? " accesskey=\"".$_accesskey."\"": null).">": null;
			$_link_close = $_valid_url? "</a pc2m_converted>": null;
			$_inner_element = preg_replace("/<(?:pre|plaintext|p|ul|ol|li|dl|dt|dd)[^>]*?>/si", null, trim($matches[2]));
			$_inner_element = preg_replace("/<\/(?:pre|plaintext|p|ul|ol|li|dl|dt|dd)[^>]*?>/si", "<br>", $_inner_element);
			if (!preg_match_all("/<(?:img|image)\b[^>]+?>/si", $_inner_element, $matches)) {
				return $_link.$_inner_element.$_link_close;
			} else {
				if (IMAGE_CONVERTER and $local_args["v"]) {
					if (preg_match_all("/<(?:img|image)\b[^>]+?>/si", $_inner_element, $matches)) {
						for ($i = 0; $i < count($matches[0]); $i++) {
							$_url = transAbsolutePath(getAttribute("src", $matches[0][$i]));
							$_width = getAttribute("width", $matches[0][$i]);
							$_align = null;
							if ($local_args["l"]) {
								$_align = getAttribute("align", $matches[0][$i]);
							}
							if ($local_args["v"] == 2
								or (!$_width
								or !is_numeric($_width)
								or $_width > ($local_args["w"]? $local_args["w"]: $client->screen["width"]))) {
								$_url = addImageProxyURL($_url);
							}
							$replace = "<img src=\"".$_url."\"".
								($_align? " align=\"".$_align."\"": null).
								" pc2m_converted>";
							$_inner_element = str_replace($matches[0][$i], $replace, $_inner_element);
						}
					}
					return $_link.$_inner_element.$_link_close;
				}
				for ($i = 0; $i < count($matches[0]); $i++) {
					$_url = getAttribute("src", $matches[0][$i]);
					$_width = getAttribute("width", $matches[0][$i]);
					$_height = getAttribute("height", $matches[0][$i]);
					$_alt = getAttribute("alt", $matches[0][$i]);
					if ($_alt === null and isset($_title)) {
						$_alt = $_title;
					}
					if ($_alt === null) {
						$_alt = getAttribute("name", $matches[0][$i]);
					}
					if ($_alt === null) {
						$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
					} else {
						$_alt = preg_replace("/^\[(.+)\]$/", "$1", $_alt);
					}
					if (($_width or $_height)
						and (!is_numeric($_width.$_height)
						or (defined("IMG_THRESHOLD") and is_int(IMG_THRESHOLD)
						and (($_width and (int) $_width < IMG_THRESHOLD)
						or ($_height and (int) $_height < IMG_THRESHOLD))))) {
						$replace = "[".$_link.$_alt.$_link_close."]";
					} else {
						$replace = "[".$_link.$_alt.$_link_close.
							"<a href=\"".addProxyURL(transAbsolutePath($_url))."\">+</a pc2m_converted>]";
					}
					$_result = str_replace($matches[0][$i], $replace, $_inner_element);
				}
				if (preg_match("/^(.+?)(\[.+)/s", $_result, $matches)) {
					if (preg_match("/^\s*(?:<br[^>]*?>\s*){1,}\s*$/s", $matches[1])) {
						$_result = "<br>".$matches[2];
					} elseif (!preg_match("/^\s+$/s", $matches[1])) {
						$_result = $_link.$matches[1].$_link_close.$matches[2];
					}
				}
				if (preg_match("/^(.+\])(.+)$/s", $_result, $matches)) {
					if (preg_match("/^\s*(?:<br[^>]*?>\s*){1,}\s*$/s", $matches[2])) {
						$_result = $matches[1]."<br>";
					} elseif (!preg_match("/^\s+$/s", $matches[2])) {
						$_result = $matches[1].$_link.$matches[2].$_link_close;
					}
				}
				if (preg_match_all("/\](.+?)\[/s", $_result, $matches)) {
					for ($i = 0; $i < count($matches[0]); $i++) {
						if (preg_match("/^\s*(?:<br[^>]*?>\s*){1,}\s*$/s", $matches[1][$i])) {
							$replace = "]<br>[";
						} elseif (!preg_match("/^\s+$/s", $matches[1][$i])) {
							$replace = "]".$_link.$matches[1][$i].$_link_close."[";
						}
						$_result = str_replace($matches[0][$i], $replace, $_result);
					}
				}
				return $_result;
			}
		'), $_content);
	$_content = preg_replace_callback(
		'/<\/a\b[^>]*?>/si',
		create_function('$matches', '
			return strpos($matches[0], "pc2m_converted")? "</a>": null;
		'), $_content);
	$_content = preg_replace_callback(
		'/(<object\b[^>]*?>)(.*?)<\/object\b[^>]*?>/si',
		create_function('$matches', '
			$_alt = null;
			$_url = getAttribute("data", $matches[1]);
			$_type = getAttribute("type", $matches[1]);
			foreach (getTagLines("param", $matches[2]) as $_node) {
				switch (strtolower(getAttribute("name", $_node))) {
					case "title":
						$_alt = getAttribute("value", $_node);
						break;
					case "movie":
					case "filename":
					case "url":
					case "src":
						if (null === $_url) {
							$_url = getAttribute("value", $_node);
						}
						break;
				}
			}
			if ($_alt === null) {
				$_alt = getAttribute("name", $matches[1]);
			}
			if (null === $_alt) {
				$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
			}
			return $_url? "[<a href=\"".addProxyURL(transAbsolutePath($_url))."\">".
				$_alt.($_type? "(".$_type.")": null)."</a>]": null;
		'), $_content);
	$_content = preg_replace_callback(
		'/<\/?embed\b[^>]*?>/si',
		create_function('$matches', '
			$_url = getAttribute("src", $matches[0]);
			$_type = getAttribute("type", $matches[0]);
			$_alt = getAttribute("alt", $matches[0]);
			if ($_alt === null) {
				$_alt = getAttribute("title", $matches[0]);
			}
			if ($_alt === null) {
				$_alt = getAttribute("name", $matches[0]);
			}
			if ($_alt === null) {
				$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
			}
			return $_url? "[<a href=\"".addProxyURL(transAbsolutePath($_url))."\">".
				$_alt.($_type? "(".$_type.")": null)."</a>]": null;
		'), $_content);
	$_content = preg_replace_callback(
		'/<(img|image)\b[^>]+?>/si',
		create_function('$matches', '
			global $client;
			global $local_args;
			if ($local_args["v"] and strpos($matches[0], "pc2m_converted")) {
				return str_replace(" pc2m_converted", null, $matches[0]);
			}
			$_url = getAttribute("src", $matches[0]);
			$_width = getAttribute("width", $matches[0]);
			$_height = getAttribute("height", $matches[0]);
			if (($_width or $_height)
				and (!is_numeric($_width.$_height)
				or (defined("IMG_THRESHOLD")
				and (($_width and (int) $_width < IMG_THRESHOLD)
				or ($_height and (int) $_height < IMG_THRESHOLD))))) {
				return null;
			}
			if (IMAGE_CONVERTER and $local_args["v"]) {
				$_url = transAbsolutePath($_url);
				$_align = null;
				if ($local_args["l"]) {
					$_align = getAttribute("align", $matches[0]);
				}
				if ($local_args["v"] == 2
					or (!$_width
					or !is_numeric($_width)
					or $_width > ($local_args["w"]? $local_args["w"]: $client->screen["width"]))) {
					$_url = addImageProxyURL($_url);
				}
				return "<img src=\"".$_url."\"".
					($_align? " align=\"".$_align."\"": null).
					">";
			} else {
				$_alt = getAttribute("alt", $matches[0]);
				if ($_alt === null) {
					$_alt = getAttribute("title", $matches[0]);
				}
				if ($_alt === null) {
					$_alt = getAttribute("name", $matches[0]);
				}
				if ($_alt === null) {
					$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
				} else {
					$_alt = preg_replace("/^\[(.+)\]$/", "$1", $_alt);
				}
				$_url = addProxyURL(transAbsolutePath($_url));
				return "[{$_alt}<a href=\"{$_url}\">+</a>]";
			}
		'), $_content);
	$search = array();
	$replace = array();
	foreach (getTagLines('area', $_content) as $_node) {
		$_url = getAttribute('href', $_node);
		$_alt = getAttribute('alt', $_node);
		if ($_alt === null) {
			$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
		}
		$_url = addProxyURL(transAbsolutePath($_url));
		$search[] = $_node;
		$replace[] = '<a href="'.$_url.'">'.$_alt.'</a>';
	}
	if ($replace) {
		$_content = str_replace($search, $replace, $_content);
	}
	$_content = preg_replace_callback(
		'/<frame\b[^>]+?>/si',
		create_function('$matches', '
			$_url = getAttribute("src", $matches[0]);
			$_alt = getAttribute("title", $matches[0]);
			if ($_alt == null) {
				$_alt = getAttribute("name", $matches[0]);
			}
			if ($_alt == null) {
				$_alt = mb_strimwidth(getFilename($_url), 0, 11, "...");
			}
			$_url = addProxyURL(transAbsolutePath($_url));
			return "<a href=\"{$_url}\">{$_alt}</a>";
		'), $_content);
	$_content = preg_replace_callback(
		'/<select\b[^>]+?>/si',
		create_function('$matches', '
			$_name = str_replace(".", "x2E", getAttribute("name", $matches[0]));
			return "<select".
				(($_name !== null)? " name=\"".$_name."\"": null).
				">";
		'), $_content);
	$search = array();
	$replace = array();
	foreach (getTagLines('input', $_content) as $_node) {
		$_type = getAttribute('type', $_node);
		$_name = str_replace('.', 'x2E', getAttribute('name', $_node));
		$_size = getAttribute('size', $_node);
		$_value = preg_replace("/(?:\r\n|\r|\n)/", "<linebreak>",
			str_replace("\x20", "<whitespace>",
				str_replace("\t", "<tabstop>", getAttribute('value', $_node)))).
		$_istyle = getAttribute('istyle', $_node);
		$_checked = preg_match('/\bchecked\b/i', $_node)? true: false;
		$_error = null;
		if ($_name == '__VIEWSTATE' and strlen($_value) > 1000) {
			$_error = '';
		}
		switch (strtolower($_type)) {
			case 'image':
				$_name .= 'x78x79';
				$_type = 'submit';
				if (null === $_value = getAttribute('alt', $_node)) {
					$_value = 'SUBMIT';
				}
				break;
			case 'button':
				$_type = 'submit';
				break;
			case 'password':
				if (!isset($_SESSION) or !SHOW_PASSINPUT) {
					$_error = '<font color="#ff0000">'.sayError('ERROR_PASSINPUT_DISABLED').'</font>';
					$_is_error = false;
				} else {
					$_type = 'text';
					if ($_istyle === null) {
						$_istyle = '3';
					}
				}
				break;
		}
		$search[] = $_node;
		$replace[] = ($_error !== null)? $_error:
			'<input'.
			(($_type !== null)? ' type="'.$_type.'"': null).
			(($_name !== null)? ' name="'.$_name.'"': null).
			(($_size !== null)? ' size="'.$_size.'"': null).
			(($_value !== null)? ' value="'.$_value.'"': null).
			(($_istyle !== null)? ' istyle="'.$_istyle.'"': null).
			($_checked? ' checked="checked"': null).
			'>';
	}
	if ($replace) {
		$_content = str_replace($search, $replace, $_content);
	}
	$_content = preg_replace_callback(
		'/<form\b[^>]*?>/si',
		create_function('$matches', '
			global $client;
			global $local_args;
			global $form_hidden;
			global $_current_url;
			global $_remote_charset;
			$_method = getAttribute("method", $matches[0]);
			if ($_method == null) {
				$_method = "get";
			}
			$_action = transAbsolutePath(getAttribute("action", $matches[0]));
			if (preg_match("/^.+\.2ch\.net\/test\/bbs\.cgi$/", $_action)) {
				return "<form action=\"".$_action."\" method=\"post\" utn>";
			}
			if ($_action == null) {
				$_action = preg_replace("/^([^\?]+).*$/", "$1", $_current_url["url"]);
			}
			return "<form action=\"".basename($_SERVER["SCRIPT_NAME"])."\" method=\"".
				($client->is_postcapable? "post": "get")."\">".$form_hidden.
				"<input type=\"hidden\" name=\"".KEY_PREFIX."e\" value=\"".$_remote_charset."\">
				<input type=\"hidden\" name=\"".KEY_PREFIX."m\" value=\"".$_method."\">
				<input type=\"hidden\" name=\"".KEY_PREFIX."u\" value=\"".$_action."\">";
		'), $_content);
	if ($local_args['l']) {
		$_content = preg_replace_callback(
			'/(<table\b[^>]*?>)(.*?)<\/table\b[^>]*?>/si',
			create_function('$matches', '
				$_bgcolor = getAttribute("bgcolor", $matches[1]);
				return $_bgcolor? "<coloredblock ".$_bgcolor.">".$matches[0]."</coloredblock>": $matches[0];
			'), $_content);
	}
	$_content = preg_replace_callback(
		'/<t[hd]\b[^>]*?>([^<]*?)<\/t[hd]\b[^>]*?>/si',
		create_function('$matches', '
			return preg_match("/^\s*$/", $matches[1])? null: $matches[0];
		'), $_content);
	$_content = preg_replace_callback(
		'/<tr\b[^>]*?>([^<]*?)<\/tr\b[^>]*?>/si',
		create_function('$matches', '
			return preg_match("/^\s*$/", $matches[1])? null: $matches[0];
		'), $_content);
	$search = array(
		"'<(\/?)table\b[^>]*?>'si",
		"'<tr\b[^>]*?>[^<]*?<t[hd]\b[^>]*?>'si",
		"'<\/t[hd]\b[^>]*?>[^<]*?<\/tr\b[^>]*?>'si",
		"'<\/t[hd]\b[^>]*?>[^<]*?<t[hd]\b[^>]*?>'si",
		"'<t[hd]\b[^>]*?>'si",
		"'<\/t[hd]\b[^>]*?>'si",
	);
	$replace = array(
		"<\\1p>",
		"<br>",
		null,
		"\x20",
		null,
		null,
	);
	$_content = preg_replace($search, $replace, $_content);
	$_content = preg_replace('/<coloredblock\s([^>]+?)>/', '<table bgcolor="$1"><tr><td>', $_content);
	$_content = str_replace('</coloredblock>', '</td></tr></table>', $_content);
	$_content = replaceChars($_content);
	$_content = str_replace("\t", "\x20", $_content);
	$_content = preg_replace('/\s+/s', "\x20", $_content);
	$search = array(
		"'(?:<hr>\x20*){2,}'si",
		"'<br>\x20+'si",
		"'\x20+<br>'si",
		"'(?:<br>){3,}'si",
		"'<p\b([^>]*?)>\x20+'si",
		"'</p\b([^>]*?)>\x20+'si",
		"'\x20+<p\b([^>]*?)>'si",
		"'\x20+</p\b([^>]*?)>'si",
		"'<p\b([^>]*?)>(?:<br>){1,}'si",
		"'(?:<br>){1,}<p\b([^>]*?)>'si",
		"'<\/p>(?:<br>){1,}'si",
		"'(?:<br>){1,}<\/p>'si",
		"'<p\b([^>]*?)>(?:<br>)?<\/p>'si",
		"'(?:<p\b([^>]*?)>){2,}'si",
		"'(?:<\/p>){2,}'si",
	);
	$replace = array(
		"<hr>",
		"<br>",
		"<br>",
		"<br><br>",
		"<p\\1>",
		"</p>",
		"<p\\1>",
		"</p>",
		"<p\\1>",
		"<p\\1>",
		"</p>",
		"</p>",
		null,
		"<p\\1>",
		"</p>",
	);
	$_content = preg_replace($search, $replace, $_content);
	//$_content = preg_replace('/\x20+/s', "\x20", $_content);
	$_content = str_replace('<linebreak>', "\n",
		str_replace('<tabstop>', "\t",
		str_replace('<whitespace>', "\x20", $_content)));
	if ($_remains) {
		for ($i = 0; $i < count($_remains); $i++) {
			$_content = str_replace('<untouch_'.$i.'>', $_remains[$i], $_content);
		}
	}

/* If you want to show users the URLs mentioned in the JavaScript codes of the page,
 * remove the comment marks from the following lines (and follow other notes as well).
 * Following lines will extract URLs from the Javascript codes which are pre-saved
 * at the very beginning of this function, generate hyperlinks
 * and concatenate them with the page content.
 * The result will look like 'JS<a href="foo">1</a><a href="bar">2</a>...'.
 * Of course, you can modify the look as you like!
 */

/*
 *  if (isset($_js)) {
 *      mb_convert_variables(INT_ENC, $_remote_charset, $_js);
 *      $_js = preg_replace('/[^:]\/\/.*$/m', null, $_js);
 *      $_js = preg_replace('/\/\*.*\*\//s', null, $_js);
 *      if ($array = extractURLfromJS($_js)) {
 *          $x = 'JS';
 *          $i = 1;
 *          foreach ($array as $value) {
 *              $x .= '<a href="'.transAbsolutePath($value).'">'.$i.'</a>';
 *              $i++;
 *          }
 *          $_content = $x.'<hr>'.$_content;
 *      }
 *  }
 */

	if (preg_match('/^(?:\s*|\s*<p>\s*<\/p>\s*)$/', $_content)) {
		return sayError('ERROR_CONTENT_EMPTY');
	}
	return trim($_content);
}

/* -------------------------------------------------------------------------
	trimContent
------------------------------------------------------------------------- */

function trimContent($_content, $_trim_from = 0) {

	global $client;
	global $remote_url;
	global $title;
	global $start_link;
	global $next_link;
	global $copy_link;
	global $next_trim;
	global $total_chars;
	global $local_args;
	global $script_self;
	global $form_hidden;
	global $_remote_args;
	global $_history_key;
	$_url_length = strlen($script_self.KEY_PREFIX.'u='.urlencode($remote_url));
	$_total_bytes = mb_strwidth($_content);
	$total_chars = mb_strlen($_content);
	if ($local_args['c']) {
		$_bytes_per_page = ((int) $local_args['c'] *1000);
	} else {
		if (defined('CACHESIZE_THRESHOLD') and $client->getCacheSize() > CACHESIZE_THRESHOLD) {
			$_bytes_per_page = CACHESIZE_THRESHOLD;
		} else {
			$_bytes_per_page = $client->getCacheSize();
		}
	}
	$_bytes_per_page -= (SIZE_REDUNDANCY + (strlen($form_hidden)) + ($_url_length * URL_REDUNDANCY));
	if ($_trim_from > 0) {
		$_bytes_per_page -= $_url_length;
	}
	if ($_total_bytes > $_bytes_per_page) {
		$_bytes_per_page -= $_url_length;
	}
	if ($_bytes_per_page < 100) {
		return sayError('ERROR_CACHESIZE_TOOSMALL');
	}
	$_proceed = null;
	if ($local_args['a'] == 'h') {
		$_proceed .= KEY_PREFIX.'a=h';
	} else {
		if ($local_args['a'] == 'c') {
			$_proceed .= KEY_PREFIX.'a=c&';
		}
		if ($local_args['m'] != 'post' or strpos($remote_url, $local_args['u']) !== 0) {
			$_proceed .= KEY_PREFIX.'u='.urlencode($remote_url);
		} else {
			if (isset($_SESSION)) {
				$_proceed .= KEY_PREFIX.'u='.$_history_key;
			} else {
				$_proceed .= KEY_PREFIX.'m=post'.
					'&'.KEY_PREFIX.'e='.$local_args['e'].
					'&'.KEY_PREFIX.'u='.urlencode($local_args['u']);
				foreach ($_remote_args as $key => $value) {
					if ($value != null) {
						$_proceed .= '&'.$key.'='.$value;
					}
				}
			}
		}
	}
	if ($local_args['a'] != 'h' and $local_args['a'] != 'c') {
		$copy_link = $script_self.KEY_PREFIX.'a=c&'.$_proceed;
	}
	if ($_trim_from > 0 or $_total_bytes > $_bytes_per_page) {
		if ($_trim_from > 0) {
			$start_link = $script_self.KEY_PREFIX.'s=0&'.$_proceed;
		}
		if ($_trim_from >= $total_chars) {
			return sayError(
				'ERROR_DIVPOINT_OUTRANGE',
				number_format($_trim_from),
				number_format($total_chars),
				$start_link
			);
		}
		$_trimmed_segment = mb_strimwidth($_content, $_trim_from, $_bytes_per_page, null);
		if ($_trim_from > 0
			and mb_strpos($_trimmed_segment, '<') > mb_strpos($_trimmed_segment, '>')) {
			$_trim_from = mb_strrpos(mb_substr($_content, 0, $_trim_from), '<');
			$_trimmed_segment = mb_strimwidth($_content, $_trim_from, $_bytes_per_page, null);
		}
		$_content =& $_trimmed_segment;
		$_last_gt = mb_strrpos($_content, '>');
		if (mb_strrpos($_content, '<') > $_last_gt) {
			$_content = mb_substr($_content, 0, ($_last_gt +1));
		}
		$_added_chars = 0;
		extract(adjustTagPairs($_content, 'textarea', 'form'));
		if ($prefix !== null) {
			$_content = $prefix.$_content;
			$_added_chars += strlen($prefix);
		}
		if ($postfix !== null) {
			$_content .= $postfix;
			$_added_chars += strlen($postfix);
		}
		extract(adjustTagPairs($_content, 'select', 'form'));
		if ($prefix !== null) {
			$_content = $prefix.$_content;
			$_added_chars += strlen($prefix);
		}
		if ($postfix !== null) {
			$_content .= $postfix;
			$_added_chars += strlen($postfix);
		}
		if (!defined('CONVERT_INDENT_TAGS') or !CONVERT_INDENT_TAGS) {
			extract(adjustTagPairs($_content, 'blockquote'));
			if ($prefix !== null) {
				$_content = $prefix.$_content;
				$_added_chars += strlen($prefix);
			}
			if ($postfix !== null) {
				$_content .= $postfix;
				$_added_chars += strlen($postfix);
			}
			extract(adjustTagPairs($_content, 'dd'));
			if ($prefix !== null) {
				$_content = $prefix.$_content;
				$_added_chars += strlen($prefix);
			}
			if ($postfix !== null) {
				$_content .= $postfix;
				$_added_chars += strlen($postfix);
			}
			extract(adjustTagPairs($_content, 'dl'));
			if ($prefix !== null) {
				$_content = $prefix.$_content;
				$_added_chars += strlen($prefix);
			}
			if ($postfix !== null) {
				$_content .= $postfix;
				$_added_chars += strlen($postfix);
			}
		}
		extract(adjustTagPairs($_content, 'ul', 'li', 1));
		if ($prefix !== null) {
			$_content = $prefix.$_content;
			$_added_chars += strlen($prefix);
		}
		if ($postfix !== null) {
			$_content .= $postfix;
			$_added_chars += strlen($postfix);
		}
		extract(adjustTagPairs($_content, 'ol', 'li', 1));
		if ($prefix !== null) {
			$_content = $prefix.$_content;
			$_added_chars += strlen($prefix);
		}
		if ($postfix !== null) {
			$_content .= $postfix;
			$_added_chars += strlen($postfix);
		}
		preg_match_all('/<ul/i', $_content, $_begin_matches);
		preg_match_all('/<\/ul/i', $_content, $_end_matches);
		$_offset = count($_begin_matches[0]) - count($_end_matches[0]);
		if ($_offset > 0) {
			for ($i = 0; $i < $_offset; $i++) {
				$_content .= '</li></ul>';
			}
			$_added_chars += ($_offset * strlen('</li></ul>'));
		} else {
			for ($i = 0; $i > $_offset; $i--) {
				$_content = '<ul><li>'.$_content;
			}
			$_added_chars += abs($_offset * strlen('<ul><li>'));
		}
		preg_match_all('/<ol/i', $_content, $_begin_matches);
		preg_match_all('/<\/ol/i', $_content, $_end_matches);
		$_offset = count($_begin_matches[0]) - count($_end_matches[0]);
		if ($_offset > 0) {
			for ($i = 0; $i < $_offset; $i++) {
				$_content .= '</li></ol>';
			}
			$_added_chars += ($_offset * strlen('</li></ol>'));
		} else {
			for ($i = 0; $i > $_offset; $i--) {
				$_content = '<ol><li>'.$_content;
			}
			$_added_chars += abs($_offset * strlen('<ol><li>'));
		}
		$next_trim = $_trim_from + mb_strlen($_content) - $_added_chars;
		if ($total_chars > $next_trim) {
			$next_link = $script_self.KEY_PREFIX.'s='.$next_trim.'&'.$_proceed;
		}
	}
	return $_content;
}

/* -------------------------------------------------------------------------
	transcodeImage
------------------------------------------------------------------------- */

function transcodeImage($_original_resource, $_original_image) {

	global $new_image;
	session_write_close();
	$_original_is_truecolor = imageIsTrueColor($_original_resource);
	list($_original_width, $_original_height, $_original_type) = $_original_image;
	list($_width, $_height, $_type, $_quality) = $new_image;
	$_new_resource = imageCreateTrueColor($_width, $_height);
	if (!$_original_is_truecolor) {
		imagefill($_new_resource, 0, 0, imageColorAllocate($_new_resource, 255, 255, 255));
	}
	imageCopyResampled(
		$_new_resource, $_original_resource,
		0, 0, 0, 0,
		$_width, $_height,
		$_original_width, $_original_height
	);
	$_use_ratio = false;
	if ($_quality != '' and preg_match('/^(\d{1,3})[^\d\s]/', $_quality, $matches)) {
		$_quality = $matches[1];
		$_use_ratio = true;
	}
	if ($_type != 2) {
		if ($_quality === '' or $_quality === null) {
			if (!$_original_is_truecolor) {
				imageTrueColorToPalette($_new_resource, true, 256);
				imagePaletteCopy($_new_resource, $_original_resource);

				/* Following if-else statement is an alternative choice.
				 * It will dither by 32 colors if the source palette contains less colors.
				 * Otherwise it will dither by 256 colors and then copy the source palette.
				 */

				/*
				 *  if (imageColorsTotal($_original_resource) < 32) {
				 *      imageTrueColorToPalette($_new_resource, false, 32);
				 *  } else {
				 *      imageTrueColorToPalette($_new_resource, false, 256);
				 *      imagePaletteCopy($_new_resource, $_original_resource);
				 *  }
				 */

			} else {
				imageTrueColorToPalette($_new_resource, true, pow(2, AVERAGE_PALETTE_BIT));
			}
			if (imageColorTransparent($_original_resource) > 0) {
				imageColorTransparent($_new_resource, imageColorClosest($_new_resource, 255, 255, 255));
			}
		} else {
			if ($_use_ratio) {
				if (!$_original_is_truecolor) {
					$i = imageColorsTotal($_original_resource);
					$_base = 1;
					while ($i > 2) {
						$i = $i /2;
						$_base++;
					}
				} else {
					$_base = AVERAGE_PALETTE_BIT;
				}
				if ($_quality == AVERAGE_COMPRESSION_RATIO) {
					$_bit = $_base;
				} elseif ($_quality < AVERAGE_COMPRESSION_RATIO) {
					$_bit = $_quality * (($_base -1) / AVERAGE_COMPRESSION_RATIO) +1;
				} elseif ($_quality > AVERAGE_COMPRESSION_RATIO) {
					$_bit = ($_quality -AVERAGE_COMPRESSION_RATIO) * ((8 - $_base) / (100 - AVERAGE_COMPRESSION_RATIO)) + $_base;
				}
				$_quality = pow(2, round($_bit));
			}
			if ($_quality < 1) {
				$_quality = 1;
			}
			if ($_quality > 256) {
				$_quality = 256;
			}
			imageTrueColorToPalette($_new_resource, true, $_quality);
		}
	}
	ob_start();
		switch ($_type) {
			case 1:
				$_output_type = 'image/gif';
				imageGIF($_new_resource);
				break;
			case 2:
				if ($_quality === '' or $_quality === null) {
					$_quality = AVERAGE_COMPRESSION_RATIO;
				}
				if ($_quality < 0) {
					$_quality = 0;
				}
				if ($_quality > 100) {
					$_quality = 100;
				}
				$_output_type = 'image/jpeg';
				imageJPEG($_new_resource, null, $_quality);
				break;
			case 3:
				$_output_type = 'image/png';
				imagePNG($_new_resource);
		}
		$_output_buffer = ob_get_contents();
		$_output_length = ob_get_length();
	ob_end_clean();
	imageDestroy($_original_resource);
	imageDestroy($_new_resource);
	header("Content-Type:".$_output_type);
	header("Content-Length:".$_output_length);
	echo $_output_buffer;
	exit;
}

function getNewImageInfo($_original_image) {

	global $client;
	global $local_args;
	$_new_image = array(
		$local_args['w'],
		$local_args['h'],
		$local_args['t'],
		$local_args['q']
	);
	if (!$_new_image[2]) {
		$_new_image[2] = $_original_image[2];
	}
	$client->getScreenInfo();
	switch($client->screen['gif_support']
		+ $client->screen['jpg_support']
		+ $client->screen['png_support']) {
		case 1:
			if ($client->screen['gif_support']) {$_new_image[2] = 1;}
			if ($client->screen['jpg_support']) {$_new_image[2] = 2;}
			if ($client->screen['png_support']) {$_new_image[2] = 3;}
			break;
		case 2:
			switch ($_new_image[2]) {
				case 1:
					$_new_image[2] = $client->screen['gif_support']? 1: 3;
					break;
				case 2:
					$_new_image[2] = $client->screen['jpg_support']? 2: 3;
					break;
				case 3:
					$_new_image[2] = $client->screen['png_support']? 3: 1;
			}
			break;
	}
	if ($_new_image[3]) {
		if (preg_match('/^(\d{1,3})([^\d\s])/', $_new_image[3], $matches)) {
			$_new_image[3] = $matches[1];
			$_ratio_identifier = $matches[2];
		}
		if (isset($_ratio_identifier) or $_new_image[2] == 2) {
			if ($_new_image[3] < 0) {
				$_new_image[3] = 0;
			}
			if ($_new_image[3] > 100) {
				$_new_image[3] = 100;
			}
			if (isset($_ratio_identifier)) {
				$_new_image[3] = $_new_image[3].$_ratio_identifier;
			}
		} else {
			if ($_new_image[3] < 1) {
				$_new_image[3] = 1;
			}
			if ($_new_image[3] > 256) {
				$_new_image[3] = 256;
			}
		}
	}
	if ($_new_image[0] > $_new_image[1] and $_new_image[0] > ALLOWABLE_PIXSIZE) {
		$_new_image[0] = ALLOWABLE_PIXSIZE;
	}
	if ($_new_image[1] > $_new_image[0] and $_new_image[1] > ALLOWABLE_PIXSIZE) {
		$_new_image[1] = ALLOWABLE_PIXSIZE;
	}
	if ($_new_image[0] or $_new_image[1]) {
		$_new_image[0] = $_new_image[0]? $_new_image[0]: round($_original_image[0] * $_new_image[1] / $_original_image[1]);
		$_new_image[1] = $_new_image[1]? $_new_image[1]: round($_original_image[1] * $_new_image[0] / $_original_image[0]);
	} else {
		$_new_image[0] = $client->screen['width'];
		$_new_image[1] = round($_original_image[1] * $client->screen['width'] / $_original_image[0]);
	}
	if ($_new_image[0] > $_original_image[0]) {
		$_new_image[0] = $_original_image[0];
	}
	if ($_new_image[1] > $_original_image[1]) {
		$_new_image[1] = $_original_image[1];
	}
	return array(
		$_new_image[0],
		$_new_image[1],
		$_new_image[2],
		$_new_image[3]
	);
}

/* -------------------------------------------------------------------------
	Miscellaneous Functions
------------------------------------------------------------------------- */

function sayError($_error_string) {

	global $client;
	global $local_args;
	global $remote_url;
	global $form_hidden;
	global $_is_error;
	global $_kana_convopt;
	$_is_error = true;
	if (false === $_messages = @include 'ErrorMessages.inc.php') {
		$_message =& $_error_string;
	} else {
		if (isset($_messages[$_error_string])) {
			$_message =& $_messages[$_error_string];
		} else {
			$_message =& $_error_string;
		}
	}
	$args = func_get_args();
	for ($i = 1; $i < count($args); $i++) {
		$search = "'{%".$i."}'";
		$_message = preg_replace($search, "$args[$i]", $_message);
	}
	if ($_error_string == 'ERROR_CONFIRM_POST') {
		$_message .= '<br><a href="'.
			$_SERVER['REQUEST_URI'].'&'.KEY_PREFIX.'o=1">YES</a>|<a href="'.
			$_SERVER['REQUEST_URI'].'&'.KEY_PREFIX.'o=0">NO</a>';
	} elseif ($_error_string == 'ERROR_AUTH_REQUIRED') {
		$_message .= '<br><form action="'.basename($_SERVER['SCRIPT_NAME']).'" method="'.
			($client->is_postcapable? "post": "get")."\">".$form_hidden.'<input type="hidden" name="'.
			KEY_PREFIX.'e" value="SJIS"><input type="hidden" name="'.
			KEY_PREFIX.'m" value="get"><input type="hidden" name="'.
			KEY_PREFIX.'u" value="'.$remote_url.'"><input type="hidden" name="'.
			KEY_PREFIX.'r" value="'.$args[2].'">USER<input type="text" name="'.
			KEY_PREFIX.'i" istyle="3"><br>PASS<input type="text" name="'.
			KEY_PREFIX.'p" istyle="3"><br><input type="submit" value="OK"></form>';
	}
	return mb_convert_kana($_message, $_kana_convopt);
}

function replaceChars($_string) {

	global $replace_chars;
	$_string = mb_decode_numericentity($_string,
		array(
			0x2000, 0xDFFF, 0x0000, 0xFFFF,
			0xFA00, 0xFFFF, 0x0000, 0xFFFF,
		)
	);
	if (isset($replace_chars)) {
		$search = array();
		$replace = array();
		foreach ($replace_chars as $key => $value) {
			$search[] = $key;
			$replace[] = $value;
		}
		return preg_replace($search, $replace, $_string);
	} else {
		return $_string;
	}
}

function checkCharset($_string) {

	$_string = preg_replace('/^x-(.+)$/', '$1', $_string);
	$search = "'^(?:".
		"UTF-(?:7|8|16|32)(?:BE|LE)?|".
		"SJIS|Shift_JIS|EUC-(?:JP|CN|TW|KR)|ISO-2022-(?:JP||CN|KR)|".
		"ISO-8859-(?:8-I|[1-9]|1[0-6])|Windows-125[0-8]|Windows-874|IBM-8(?:6[24]|5[0257])|".
		"GB(?:2312|K|18030)|HZ|".
		"Big5|Big5-HKSCS|".
		"UHC|JOHAB|".
		"ARMSCII-8|GEOSTD8|TIS-620|TCVN|VISCII|VPS|".
		"Mac(?:Arabic|CE|Croatian|Cyrillic|Devanagari|Farsi|Greek|Gujarati|Gurmukhi|Hebrew|Icelandic|Ukrainian|Romanian|Roman|Turkish)|".
		"CP-866|ISO-IR-111|KOI8-(?:R|U)".
		")$'i";
	if (preg_match($search, $_string)) {
		return $_string;
	} else {
		return null;
	}
}

function transAbsolutePath($_path) {

	global $_base_href;
	global $_current_url;
	$_wrapper = null;
	if (preg_match('/^(http:\/\/web\.archive\.org\/web\/\d{14}\/)/', $_current_url['url'], $matches)) {
		$_wrapper = $matches[1];
	}
	if (preg_match('/^\w+:/i', $_path)) {
		return $_wrapper.$_path;
	}
	if (!isset($_base_href)) {
		$_remote_host = $_current_url['scheme'].'://'.$_current_url['host'].
			((isset($_current_url['port']) and $_current_url['port'] != 80)?
			':'.$_current_url['port']: null);
		$_remote_path = isset($_current_url['path'])? $_current_url['path']: '/';
		$_remote_dir = $_remote_path? getDirName($_remote_path): '/';
	} else {
		$array = parse_url($_base_href);
		$_remote_host = $array['scheme'].'://'.$array['host'].
			((isset($array['port']) and $array['port'] != 80)?
			':'.$array['port']: null);
		$_remote_path = isset($array['path'])? $array['path']: '/';
		$_remote_dir = $_remote_path? getDirName($_remote_path): '/';
	}
	$_path = preg_replace('/^\.\//', null, $_path);
	$search = "'^((?:\.\.\/){1,})'";
	if (preg_match($search, $_path, $matches)) {
		$_path = substr($_path, strlen($matches[1]));
		$count = strlen($matches[1]) / 3;
		$array = explode('/', $_remote_dir);
		array_pop($array);
		while ($count) {
			array_pop($array);
			$count--;
		}
		$_remote_dir = implode('/', $array);
		$_remote_dir .= '/';
	}
	if (preg_match('/^\//', $_path)) {
		$_path = $_remote_host.$_path;
	}
	if (preg_match('/^#/', $_path)) {
		$_url = isset($_current_url['fragment'])?
			str_replace('#'.$_current_url['fragment'], null, $_current_url['url']):
			$_current_url['url'];
		$_path = $_url.$_path;
	}
	if (preg_match('/^(?!https?:\/\/)/i', $_path)) {
		$_path = $_remote_host.$_remote_dir.$_path;
	}
	return $_wrapper.$_path;
}

function addProxyURL($_url) {

	global $script_self;
	if (preg_match('/^https?:\/\/www\.amazon\.co\.jp/i', $_url)) {
		if (preg_match('/\/exec\/obidos\/(?:ASIN\/|ISBN(?:=|%3D))(\w{10}).*?\/?(\w+-22)?/i', $_url, $matches)) {
			$_asin = $matches[1];
			$_associd = isset($matches[2])? $matches[2]: null;
		} elseif (preg_match('/\/exec\/obidos\/redirect\?(.+)$/i', $_url, $matches)) {
			$_query = $matches[1];
			if (preg_match('/&?\btag=(\w+-22)&?/i', $_query, $matches)) {
				$_associd = $matches[1];
			}
			if (preg_match('/&?\bpath=[^&]*?(?:ASIN(?:\/|%2F)|ISBN(?:=|%3D))(\w{10})&?/i', $_query, $matches)) {
				$_asin = $matches[1];
			}
		}
		if (isset($_asin)) {
			return 'http://www.amazon.co.jp/gp/aw/rd.html?a='.
				$_asin.'&amp;uid=NULLGWDOCOMO&amp;url=/gp/aw/d.html&amp;lc=msn'.
				(isset($_associd)? '&amp;at='.$_associd: null).'&amp;dl=1';
		}
	}
	if (!preg_match('/^https?:\/\//', $_url)) {
		return $_url;
	}
	return $script_self.KEY_PREFIX.'u='.urlencode($_url);
}

function addImageProxyURL($_url) {

	global $local_args;
	global $script_self;
	$image_converter = IMAGE_CONVERTER.'?';
	if ($local_args['d'] !== null and !ENABLE_SESSION_COOKIE) {
		$image_converter = $image_converter.strip_tags(SID).'&';
	}
	return $image_converter.
		KEY_PREFIX.'a=i&'.
		(($local_args['w'] !== null)? KEY_PREFIX.'w='.$local_args['w'].'&': null).
		(($local_args['h'] !== null)? KEY_PREFIX.'h='.$local_args['h'].'&': null).
		(($local_args['t'] !== null)? KEY_PREFIX.'t='.$local_args['t'].'&': null).
		(($local_args['q'] !== null)? KEY_PREFIX.'q='.$local_args['q'].'&': null).
		KEY_PREFIX.'u='.urlencode($_url);
}

function adjustTagPairs($_string, $_tag, $_supplemental_tag = null, $_supplement_position = 0) {

	$_postfix = null;
	$_tag_begin = mb_strrpos(strtolower($_string), '<'.$_tag);
	$_tag_end = mb_strrpos(strtolower($_string), '</'.$_tag);
	if ($_tag_begin !== false) {
		if ($_tag_end  === false or $_tag_begin > $_tag_end) {
			$_postfix =
				(($_supplemental_tag and $_supplement_position === 1)? '</'.$_supplemental_tag.'>': null).
				'</'.$_tag.'>'.
				(($_supplemental_tag and $_supplement_position === 0)? '</'.$_supplemental_tag.'>': null);
		}
	}
	$_prefix = null;
	$_tag_begin = mb_strpos(strtolower($_string), '<'.$_tag);
	$_tag_end = mb_strpos(strtolower($_string), '</'.$_tag);
	if ($_tag_end !== false) {
		if ($_tag_begin === false or $_tag_begin > $_tag_end) {
			$_prefix =
				(($_supplemental_tag and $_supplement_position === 0)?
					(($_supplemental_tag == 'form')?
					'<form action="'.basename($_SERVER['SCRIPT_NAME']).'">': '<'.$_supplemental_tag.'>'): null).
				'<'.$_tag.'>'.
				(($_supplemental_tag and $_supplement_position === 1)? '<'.$_supplemental_tag.'>': null);
		}
	}
	return array('postfix' => $_postfix, 'prefix' => $_prefix);
}

function getDirName($_path) {

	return substr($_path, 0, strrpos($_path, '/') +1);
}

function removeQuote($_string) {

	return preg_replace('/^\s*[\'\"](.+)[\'\"]\s*$/s', '$1', $_string);
}

function getAttribute($_param, $_string) {

	$search = "'[\s\'\"]\b".$_param."\b\s*=\s*([^\s\'\">]+|\'[^\']+\'|\"[^\"]+\")'si";
	if (preg_match($search, $_string, $matches)) {
		return removeQuote($matches[1]);
	} else {
		return null;
	}
}

function getFilename($_url) {

	if (preg_match('/^(\w+):(.+)$/', $_url, $matches)
		and !preg_match('/^(?:https?|ftps?)/', $matches[1])) {
		return $matches[2];
	} else {
		$array = @parse_url($_url);
		if ($array) {
			if (isset($array['path']) and basename($array['path']) != null) {
				return preg_replace('/^(.+)\.\w+$/', '$1', basename($array['path']));
			} elseif (isset($array['fragment'])) {
				return $array['fragment'];
			} elseif (isset($array['host'])) {
				return preg_replace('/^www\./', null, $array['host']);
			}
		} else {
			return $_url;
		}
	}
}

function getTagLines($_tag, $_string) {

	$array = array();
	while (false !== $_return = getATagLine($_tag, $_string)) {
		$array[] = $_return[0];
		$_string = $_return[1];
	}
	return $array;
}

function getATagLine($_tag, $_string) {

	if (preg_match('/(<'.$_tag.'\b[^>]*?>)(.*)/si', $_string, $matches)) {
		$_tag_line = $matches[1];
		$_latter_line = $matches[2];
		while (!is_int(substr_count($_tag_line, '"') /2)) {
			if (preg_match('/(.*?"[^>]*?>)(.*)/s', $_latter_line, $matches)) {
				$_tag_line .= $matches[1];
				$_latter_line = $matches[2];
			} else {
				break;
			}
		}
		while (!is_int(substr_count($_tag_line, '\'') /2)) {
			if (preg_match('/(.*?\'[^>]*?>)(.*)/s', $_latter_line, $matches)) {
				$_tag_line .= $matches[1];
				$_latter_line = $matches[2];
			} else {
				break;
			}
		}
		return array($_tag_line, $_latter_line);
	} else {
		return false;
	}
}

function generateId($_length) {

	$x = "0123456789abcdefghijklmnopqrstuvwxyz";
	$_id = null;
	for ($i = 0; $i < $_length; $i++) {
		$_id .= substr($x, mt_rand(0, strlen($x) -1), 1);
	}
	return $_id;
}

function sortMultiArray($array, $_sortby) {

	$_keys = array();
	foreach ($array as $key => $value) {
		$_keys[$key] = $value[$_sortby];
	}
	array_multisort($_keys, SORT_NUMERIC, SORT_DESC, $array);
	return $array;
}

function extractURLfromJS($_string) {

	$_urls = array();
	if (preg_match_all('/(?:\bwindow\.open|\blocation\.replace|\blocation\.assign)\s*\(([^\)]+?)\)/s', $_string, $matches)) {
		foreach ($matches[1] as $value) {
			$array = explode(',', $value);
			if (preg_match('/^\s*(\'\s*[^\'\s]+\s*\'|\"\s*[^\"\s]+\s*\")\s*$/s', $array[0], $matches)) {
				$_urls[] = removeQuote($matches[1]);
			}
		}
	}
	if (preg_match_all('/\blocation\.href\s*=\s*(\'\s*[^\'\s]+\s*\'|\"\s*[^\"\s]+\s*\")\s*[;}]/s', $_string, $matches)) {
		foreach ($matches[1] as $value) {
			$_urls[] = removeQuote($value);
		}
	}
	if (preg_match_all('/\blocation\.href\s*=\s*(\'\s*[^\'\s]+\s*\'|\"\s*[^\"\s]+\s*\")\s*$/s', $_string, $matches)) {
		foreach ($matches[1] as $value) {
			$_urls[] = removeQuote($value);
		}
	}
	return $_urls;
}

?>
